/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstSerializerFormat;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;

@Feature(value="AST serialization")
@Story(value="AST Json deserialization")
@RunWith(value=Parameterized.class)
public class JsonArtifactAstDeserializerTestCase {
    private JsonArtifactAstDeserializer jsonArtifactAstDeserializer;
    private Gson gson;
    private ArtifactAstDTO artifactAstDTO;
    @Parameterized.Parameter
    public String version;

    @Parameterized.Parameters(name="version: {0}")
    public static Iterable<String> data() {
        return new JsonArtifactAstSerializerFormat().getAvailableVersions();
    }

    @Before
    public void setUp() throws Exception {
        GsonBuilder gsonBuilder = (GsonBuilder)Mockito.mock(GsonBuilder.class);
        this.gson = (Gson)Mockito.mock(Gson.class);
        Mockito.when((Object)this.gson.newBuilder()).thenReturn((Object)gsonBuilder);
        Mockito.when((Object)gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)ArgumentMatchers.any())).thenReturn((Object)gsonBuilder);
        Mockito.when((Object)gsonBuilder.create()).thenReturn((Object)this.gson);
        this.artifactAstDTO = (ArtifactAstDTO)Mockito.mock(ArtifactAstDTO.class);
        Mockito.when((Object)((ArtifactAstDTO)this.gson.fromJson((Reader)ArgumentMatchers.any(Reader.class), (Class)ArgumentMatchers.eq(ArtifactAstDTO.class)))).thenReturn((Object)this.artifactAstDTO);
        this.jsonArtifactAstDeserializer = new JsonArtifactAstDeserializer(gsonBuilder, this.version, true);
    }

    @Test
    public void testDeserializeCallGsonFromJsonForArtifactAstDTOClass_WhenDeserializingAnInputStream() throws IOException {
        InputStream artifactAstInputStream = (InputStream)Mockito.mock(InputStream.class);
        ExtensionModelResolver extensionModelResolver = (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class);
        this.jsonArtifactAstDeserializer.deserialize(artifactAstInputStream, extensionModelResolver);
        ((Gson)Mockito.verify((Object)this.gson, (VerificationMode)Mockito.times((int)1))).fromJson((Reader)ArgumentMatchers.any(Reader.class), (Class)ArgumentMatchers.eq(ArtifactAstDTO.class));
    }

    @Test
    public void testDeserializeCallGsonFromJsonResultsEnrich_WhenDeserializingAnInputStream() throws IOException {
        InputStream artifactAstInputStream = (InputStream)Mockito.mock(InputStream.class);
        ExtensionModelResolver extensionModelResolver = (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class);
        this.jsonArtifactAstDeserializer.deserialize(artifactAstInputStream, extensionModelResolver);
        ((ArtifactAstDTO)Mockito.verify((Object)this.artifactAstDTO, (VerificationMode)Mockito.times((int)1))).enrich((ExtensionModelResolver)ArgumentMatchers.any(ExtensionModelResolver.class), (GenerationInformationResolver)ArgumentMatchers.any(GenerationInformationResolver.class), (ParameterModelUtils)ArgumentMatchers.any(ParameterModelUtils.class));
    }

    @Test
    @Issue(value="MULE-19834")
    public void testDeserializeCallsResultingArtifactSetParentWithInputParent_WhenDeserializingAnInputStreamWithParent() throws IOException {
        InputStream artifactAstInputStream = (InputStream)Mockito.mock(InputStream.class);
        ExtensionModelResolver extensionModelResolver = (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class);
        ArtifactAst parent = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.jsonArtifactAstDeserializer.deserialize(artifactAstInputStream, extensionModelResolver, parent);
        ((ArtifactAstDTO)Mockito.verify((Object)this.artifactAstDTO, (VerificationMode)Mockito.times((int)1))).setParent(parent);
    }

    @Test
    public void testDeserializeReturnsEnrichedArtifactAst_WhenDeserializingAnInputStream() throws IOException {
        InputStream artifactAstInputStream = (InputStream)Mockito.mock(InputStream.class);
        ExtensionModelResolver extensionModelResolver = (ExtensionModelResolver)Mockito.mock(ExtensionModelResolver.class);
        ArtifactAst artifactAst = this.jsonArtifactAstDeserializer.deserialize(artifactAstInputStream, extensionModelResolver);
        MatcherAssert.assertThat((Object)artifactAst, (Matcher)Matchers.is((Object)this.artifactAstDTO));
    }
}

