/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.serialization.dto.EnrichedErrorTypeRepository;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class EnrichedErrorTypeRepositoryTestCase {
    private ErrorTypeRepository delegate;
    private EnrichedErrorTypeRepository repository;

    @Before
    public void setUp() {
        this.delegate = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        this.repository = new EnrichedErrorTypeRepository(this.delegate);
    }

    @Test
    public void testAddErrorTypeDelegatesIfPresent() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)identifier.getName()).thenReturn((Object)"testIdentifer");
        Mockito.when((Object)identifier.getNamespace()).thenReturn((Object)"testNamespace");
        ErrorType parentError = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorType existingError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getErrorType(identifier)).thenReturn(Optional.of(existingError));
        ErrorType result = this.repository.addErrorType(identifier, parentError);
        MatcherAssert.assertThat((Object)existingError, (Matcher)Matchers.equalTo((Object)result));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getErrorType(identifier);
    }

    @Test
    public void testAddErrorTypeCreatesNewIfAbsent() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType parentError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getErrorType(identifier)).thenReturn(Optional.empty());
        Mockito.when((Object)identifier.getNamespace()).thenReturn((Object)"testNamespace");
        Mockito.when((Object)identifier.getName()).thenReturn((Object)"testName");
        ErrorType result = this.repository.addErrorType(identifier, parentError);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)"testNamespace", (Matcher)Matchers.equalTo((Object)result.getNamespace()));
        MatcherAssert.assertThat((Object)"testName", (Matcher)Matchers.equalTo((Object)result.getIdentifier()));
    }

    @Test
    public void testLookupErrorTypeReturnsFromDelegateIfPresent() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.lookupErrorType(identifier)).thenReturn(Optional.of(errorType));
        Optional result = this.repository.lookupErrorType(identifier);
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)errorType, (Matcher)Matchers.equalTo((Object)((ErrorType)result.get())));
    }

    @Test
    public void testLookupErrorTypeReturnsFromLocalIfAbsentInDelegate() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType parentError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.lookupErrorType(identifier)).thenReturn(Optional.empty());
        Mockito.when((Object)identifier.getNamespace()).thenReturn((Object)"testNamespace");
        Mockito.when((Object)identifier.getName()).thenReturn((Object)"testName");
        this.repository.addErrorType(identifier, parentError);
        Optional result = this.repository.lookupErrorType(identifier);
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)"testNamespace", (Matcher)Matchers.equalTo((Object)((ErrorType)result.get()).getNamespace()));
        MatcherAssert.assertThat((Object)"testName", (Matcher)Matchers.equalTo((Object)((ErrorType)result.get()).getIdentifier()));
    }

    @Test
    public void testGetErrorTypesIncludesDelegateAndLocal() {
        ErrorType delegateError = (ErrorType)Mockito.mock(ErrorType.class);
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType parentError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getErrorTypes()).thenReturn(Collections.singleton(delegateError));
        Mockito.when((Object)identifier.getNamespace()).thenReturn((Object)"testNamespace");
        Mockito.when((Object)identifier.getName()).thenReturn((Object)"testName");
        this.repository.addErrorType(identifier, parentError);
        Set result = this.repository.getErrorTypes();
        MatcherAssert.assertThat((Object)result.contains(delegateError), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testGetInternalErrorTypesIncludesDelegateAndLocal() {
        ErrorType delegateError = (ErrorType)Mockito.mock(ErrorType.class);
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType parentError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getInternalErrorTypes()).thenReturn(Collections.singleton(delegateError));
        Mockito.when((Object)identifier.getNamespace()).thenReturn((Object)"testNamespace");
        Mockito.when((Object)identifier.getName()).thenReturn((Object)"testName");
        this.repository.addInternalErrorType(identifier, parentError);
        Set result = this.repository.getInternalErrorTypes();
        MatcherAssert.assertThat((Object)result.contains(delegateError), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.equalTo((Object)2));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getInternalErrorTypes();
    }

    @Test
    public void testGetErrorNamespacesCombinesNamespaces() {
        ErrorType error1 = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorType error2 = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorType internalError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)error1.getNamespace()).thenReturn((Object)"namespace1");
        Mockito.when((Object)error2.getNamespace()).thenReturn((Object)"namespace2");
        Mockito.when((Object)internalError.getNamespace()).thenReturn((Object)"internalNamespace");
        Mockito.when((Object)this.delegate.getErrorTypes()).thenReturn(new HashSet<ErrorType>(Arrays.asList(error1, error2)));
        Mockito.when((Object)this.delegate.getInternalErrorTypes()).thenReturn(Collections.singleton(internalError));
        Collection namespaces = this.repository.getErrorNamespaces();
        MatcherAssert.assertThat(new HashSet<String>(Arrays.asList("INTERNALNAMESPACE", "NAMESPACE2", "NAMESPACE1")), (Matcher)Matchers.equalTo(new HashSet(namespaces)));
    }

    @Test
    public void testGetAnyErrorTypeDelegates() {
        ErrorType anyError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getAnyErrorType()).thenReturn((Object)anyError);
        MatcherAssert.assertThat((Object)anyError, (Matcher)Matchers.equalTo((Object)this.repository.getAnyErrorType()));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getAnyErrorType();
    }

    @Test
    public void testGetSourceErrorTypeDelegates() {
        ErrorType sourceError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getSourceErrorType()).thenReturn((Object)sourceError);
        MatcherAssert.assertThat((Object)sourceError, (Matcher)Matchers.equalTo((Object)this.repository.getSourceErrorType()));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getSourceErrorType();
    }

    @Test
    public void testGetSourceResponseErrorTypeDelegates() {
        ErrorType responseError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getSourceResponseErrorType()).thenReturn((Object)responseError);
        MatcherAssert.assertThat((Object)responseError, (Matcher)Matchers.equalTo((Object)this.repository.getSourceResponseErrorType()));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getSourceResponseErrorType();
    }

    @Test
    public void testGetCriticalErrorTypeDelegates() {
        ErrorType criticalError = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getCriticalErrorType()).thenReturn((Object)criticalError);
        MatcherAssert.assertThat((Object)criticalError, (Matcher)Matchers.equalTo((Object)this.repository.getCriticalErrorType()));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getCriticalErrorType();
    }

    @Test
    public void testLookupErrorTypeDelegatesIfPresent() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.lookupErrorType(identifier)).thenReturn(Optional.of(errorType));
        Optional result = this.repository.lookupErrorType(identifier);
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)errorType, (Matcher)Matchers.equalTo((Object)((ErrorType)result.get())));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).lookupErrorType(identifier);
    }

    @Test
    public void testGetErrorTypeDelegatesIfPresent() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.delegate.getErrorType(identifier)).thenReturn(Optional.of(errorType));
        Optional result = this.repository.getErrorType(identifier);
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)errorType, (Matcher)Matchers.equalTo((Object)((ErrorType)result.get())));
        ((ErrorTypeRepository)Mockito.verify((Object)this.delegate)).getErrorType(identifier);
    }
}

