/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;

/**
 * Implementation of a MetadataVisitor used to visit a component of {@link org.mule.metadata.api.model.ArrayType}
 */
public class ArrayMetadataVisitor extends MetadataTypeVisitor {

  private final MetadataTypeVisitor metadataTypeVisitor;

  public ArrayMetadataVisitor(ComponentParameterAstDTO componentParameterAstDTO,
                              ComponentAstDTO parentComponentAstDTO,
                              ExtensionModelHelper extensionModelHelper,
                              GenerationInformationResolver generationInformationResolver,
                              ExtensionModelResolver extensionModelResolver,
                              ParameterModelUtils parameterModelUtils) {
    this.metadataTypeVisitor = new ArrayElementMetadataTypeVisitor(componentParameterAstDTO,
                                                                   parentComponentAstDTO,
                                                                   extensionModelHelper,
                                                                   generationInformationResolver,
                                                                   extensionModelResolver,
                                                                   parameterModelUtils);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void visitArrayType(ArrayType arrayType) {
    MetadataType type = arrayType.getType();
    type.accept(metadataTypeVisitor);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void visitObject(ObjectType objectType) {
    objectType.getOpenRestriction().get().accept(this);
  }
}
