/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class ComponentMetadataAstDTOTestCase {
    @Test
    @Description(value="Property resolver can be set even if document attributes are null")
    public void whenDocAttributesAreNullThenPropertyResolverCanBeSet() {
        ComponentMetadataAstDTO metadataAst = new ComponentMetadataAstDTO();
        metadataAst.enrich(Collections.emptyMap());
        metadataAst.setPropertiesResolver(new PropertiesResolver());
    }

    @Test
    @Description(value="Get document attributes when null")
    public void whenDocAttributesAreNullThenTheyCanBeRetrieved() {
        ComponentMetadataAstDTO metadataAst = new ComponentMetadataAstDTO();
        MatcherAssert.assertThat((Object)metadataAst.getDocAttributes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        metadataAst.enrich(Collections.emptyMap());
        metadataAst.setPropertiesResolver(new PropertiesResolver());
        MatcherAssert.assertThat((Object)metadataAst.getDocAttributes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Checks that document attributes with properties are resolved")
    @Issue(value="MULE-20090")
    public void attributesAreResolved() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> "10");
        Map<String, String> docAttributes = Collections.singletonMap("paramWithProperty", "${value}");
        ComponentMetadataAstDTO metadataAst = new ComponentMetadataAstDTO(docAttributes, null, null, null, null, Collections.emptyList(), null, null, null, null);
        metadataAst.enrich(Collections.emptyMap());
        metadataAst.setPropertiesResolver(propertiesResolver);
        MatcherAssert.assertThat((Object)((String)metadataAst.getDocAttributes().get("paramWithProperty")), (Matcher)CoreMatchers.is((Object)"10"));
    }

    @Test
    @Description(value="Checks that the property resolver can be hot-swapped")
    public void whenPropertyResolverIsUpdatedThenAttributesAreResolvedWithTheNewResolver() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(k -> "10");
        Map<String, String> docAttributes = Collections.singletonMap("paramWithProperty", "${value}");
        ComponentMetadataAstDTO metadataAst = new ComponentMetadataAstDTO(docAttributes, null, null, null, null, Collections.emptyList(), null, null, null, null);
        metadataAst.enrich(Collections.emptyMap());
        metadataAst.setPropertiesResolver(propertiesResolver);
        MatcherAssert.assertThat((Object)((String)metadataAst.getDocAttributes().get("paramWithProperty")), (Matcher)CoreMatchers.is((Object)"10"));
        propertiesResolver.setMappingFunction(k -> "20");
        MatcherAssert.assertThat((Object)((String)metadataAst.getDocAttributes().get("paramWithProperty")), (Matcher)CoreMatchers.is((Object)"20"));
    }
}

