/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.visitor;

import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;

import java.util.concurrent.atomic.AtomicBoolean;

public class UnionTypesVisitor extends MetadataTypeVisitor {

  private final ComponentParameterAstDTO componentParameterAstDTO;
  private final ExtensionModelHelper extensionModelHelper;
  private final AtomicBoolean paramProcessed;

  public UnionTypesVisitor(ComponentParameterAstDTO componentParameterAstDTO, ExtensionModelHelper extensionModelHelper,
                           AtomicBoolean paramProcessed) {
    this.componentParameterAstDTO = componentParameterAstDTO;
    this.extensionModelHelper = extensionModelHelper;
    this.paramProcessed = paramProcessed;
  }

  @Override
  public void visitUnion(UnionType unionType) {
    unionType.getTypes().forEach(type -> {
      ComponentAst parameterValue = (ComponentAst) componentParameterAstDTO.getValue().getRight();
      if (parameterValue != null) {
        ComponentIdentifier parameterValueIdentifier = parameterValue.getIdentifier();
        extensionModelHelper.resolveDslElementModel(type, parameterValueIdentifier.getNamespace())
            .filter(resolveDslElementModel -> resolveDslElementModel.getElementName().equals(parameterValueIdentifier.getName()))
            .ifPresent(resolveDslElementModel -> {
              paramProcessed.set(true);
              componentParameterAstDTO.setGenerationInformation(new ComponentGenerationInformationDTO(resolveDslElementModel));
            });
      }
    });
  }
}
