/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast;

import com.google.gson.Gson;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ParameterValueContainerGsonSerializationTestCase {
    private Gson gson;

    @Before
    public void setUp() throws Exception {
        this.gson = new Gson();
    }

    @Test
    public void testSerializedParameterValueContainerWithCharIsDeserializedAsChar_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)Character.valueOf('A'));
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Character.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)Character.valueOf('A')));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"character"));
    }

    @Test
    public void testSerializedParameterValueContainerWithBooleanIsDeserializedAsBoolean_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)Boolean.TRUE);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Boolean.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)Boolean.TRUE));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aBoolean"));
    }

    @Test
    public void testSerializedParameterValueContainerWithStringIsDeserializedAsString_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)"Some string");
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)"Some string"));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aString"));
    }

    @Test
    public void testSerializedParameterValueContainerWithArrayListIsDeserializedAsArrayList_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, new ArrayList());
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(ArrayList.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is(new ArrayList()));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"object"));
    }

    @Test
    public void testSerializedParameterValueContainerWithFloatIsDeserializedAsFloat_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)Float.valueOf(13.9f));
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Float.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)Float.valueOf(13.9f)));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aFloat"));
    }

    @Test
    public void testSerializedParameterValueContainerWithIntegerIsDeserializedAsInteger_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)432);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Integer.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)432));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"anInteger"));
    }

    @Test
    public void testSerializedParameterValueContainerWithLongIsDeserializedAsLong_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)78L);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Long.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)78L));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aLong"));
    }

    @Test
    public void testSerializedParameterValueContainerWithDoubleIsDeserializedAsDouble_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)74.635);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Double.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)74.635));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aDouble"));
    }

    @Test
    public void testSerializedParameterValueContainerWithByteIsDeserializedAsByte_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)127);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Byte.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)127));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aByte"));
    }

    @Test
    public void testSerializedParameterValueContainerWithShortIsDeserializedAsShort_WhenSerializingAndDeserializingParameterValueContainer() {
        ParameterValueContainer parameterValueContainer = new ParameterValueContainer(null, (Object)Short.MIN_VALUE);
        String json = this.gson.toJson((Object)parameterValueContainer);
        ParameterValueContainer deserialized = (ParameterValueContainer)this.gson.fromJson(json, ParameterValueContainer.class);
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.instanceOf(Short.class));
        MatcherAssert.assertThat((Object)deserialized.getContainedValue(), (Matcher)Matchers.is((Object)Short.MIN_VALUE));
        MatcherAssert.assertThat((Object)deserialized.toString(), (Matcher)Matchers.containsString((String)"aShort"));
    }
}

