/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.api.serialization;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.ast.api.ArtifactAst;
import java.io.InputStream;

/**
 * Defines a component capable of serializing {@link ArtifactAst}s into an {@link InputStream}.
 * <p>
 * A serialized {@link ArtifactAst} will contain the information of the original artifact and some more metadata relevant to the
 * serializer. This metadata will be entirely and exclusively in the first line of the resulting input stream, in UTF-8 encoding,
 * and will be composed by an ID corresponding to the serializer used followed by its version and the charset used in the body.
 * This values will be delimited by a pound (#) character like the following example shows: "{@code SERIALIZERID#1.2.3#UTF-8#}".
 * This metadata is required by the {@link ArtifactAstDeserializer} in order to determine which deserializer to use with the
 * provided input stream.
 *
 * @since 1.0
 */
@NoImplement
public interface ArtifactAstSerializer {

  /**
   * Serializes an {@link ArtifactAst} into an {@link InputStream} adding string metadata in the first line followed by the
   * serialized content.
   *
   * @param artifactAst The AST of the artifact to be serialized
   * @return an {@link InputStream} containing a first line with metadata (a String with serializer id and version delimited by
   *         the character '#') followed by the serialized content.
   */
  InputStream serialize(ArtifactAst artifactAst);

}
