/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.resolver;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.resolver.DefaultGenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class GenerationInformationResolverTestCase {
    private GenerationInformationResolver generationInformationResolver;
    private DefaultExtensionModelHelper extensionModelHelper;
    private ParameterizedModel parameterizedModel;
    private ParameterGroupModel paramGroupModel;
    private ParameterModel paramModel;

    @Before
    public void setUp() throws Exception {
        this.generationInformationResolver = new DefaultGenerationInformationResolver();
        this.extensionModelHelper = (DefaultExtensionModelHelper)Mockito.mock(DefaultExtensionModelHelper.class);
        this.paramModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.paramModel.getName()).thenReturn((Object)"param");
        this.paramGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)this.paramGroupModel.getName()).thenReturn((Object)"General");
        this.parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        Mockito.when((Object)this.parameterizedModel.getAllParameterModels()).thenReturn(Arrays.asList(this.paramModel));
        Mockito.when((Object)this.parameterizedModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.paramGroupModel));
    }

    @Test
    @Issue(value="MULE-19823")
    public void dslSyntaxForSubTypeParameterFromAnotherExtension() {
        ComponentIdentifier paramValueIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)paramValueIdentifier.getNamespace()).thenReturn((Object)"anotherExtension");
        MetadataType paramValueType = (MetadataType)Mockito.mock(MetadataType.class);
        ComponentAstDTO paramValueComponentAstDTO = new ComponentAstDTO(null, TypedComponentIdentifier.ComponentType.UNKNOWN.name(), paramValueIdentifier, (ComponentLocation)Mockito.mock(ComponentLocation.class), null, Collections.emptyList(), null, null, null, null, null);
        paramValueComponentAstDTO.setType(paramValueType);
        ComponentParameterAstDTO componentParameterAstDTO = new ComponentParameterAstDTO(new ParameterValueContainer(null, (Object)paramValueComponentAstDTO), null, false, null, "General", "param");
        componentParameterAstDTO.setModel(this.paramModel, this.paramGroupModel, new ParameterModelUtils());
        ComponentIdentifier paramOwnerIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentAstDTO componentAstDTO = new ComponentAstDTO(null, TypedComponentIdentifier.ComponentType.OPERATION.name(), paramOwnerIdentifier, (ComponentLocation)Mockito.mock(ComponentLocation.class), null, Collections.emptyList(), null, null, null, null, null);
        componentAstDTO.setParameterizedModel(this.parameterizedModel);
        componentAstDTO.setGenerationInformation(new ComponentGenerationInformationDTO(null));
        DslElementSyntax paramSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)paramSyntax.isWrapped()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel(this.paramModel, paramOwnerIdentifier)).thenReturn((Object)paramSyntax);
        DslElementSyntax paramValueSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)paramValueSyntax.isWrapped()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModelHelper.resolveDslElementModel(paramValueType, "anotherExtension")).thenReturn(Optional.of(paramValueSyntax));
        ComponentGenerationInformationDTO componentGenerationInformationDTO = this.generationInformationResolver.resolveComponentParameterAstGenerationInformation(componentParameterAstDTO, componentAstDTO, (ExtensionModelHelper)this.extensionModelHelper);
        ((DefaultExtensionModelHelper)Mockito.verify((Object)this.extensionModelHelper)).resolveDslElementModel(paramValueComponentAstDTO.getType(), paramValueComponentAstDTO.getIdentifier().getNamespace());
        MatcherAssert.assertThat((Object)((DslElementSyntax)componentGenerationInformationDTO.getSyntax().get()), (Matcher)Matchers.is((Object)paramValueSyntax));
    }

    @Test
    @Issue(value="MULE-19827")
    public void dslSyntaxAvoidHelperResolutionIfAvailableFromParent() {
        DslElementSyntax ownerSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        DslElementSyntax paramSyntax = (DslElementSyntax)Mockito.mock(DslElementSyntax.class);
        Mockito.when((Object)ownerSyntax.getChild("param")).thenReturn(Optional.of(paramSyntax));
        ComponentIdentifier paramOwnerIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentAstDTO componentAstDTO = new ComponentAstDTO(null, TypedComponentIdentifier.ComponentType.OPERATION.name(), paramOwnerIdentifier, (ComponentLocation)Mockito.mock(ComponentLocation.class), null, Collections.emptyList(), null, null, null, null, null);
        componentAstDTO.setParameterizedModel(this.parameterizedModel);
        componentAstDTO.setGenerationInformation(new ComponentGenerationInformationDTO(ownerSyntax));
        ComponentParameterAstDTO componentParameterAstDTO = new ComponentParameterAstDTO(new ParameterValueContainer(null, (Object)"hello"), null, false, null, "General", "param");
        componentParameterAstDTO.setModel(this.paramModel, this.paramGroupModel, new ParameterModelUtils());
        ComponentGenerationInformationDTO componentGenerationInformationDTO = this.generationInformationResolver.resolveComponentParameterAstGenerationInformation(componentParameterAstDTO, componentAstDTO, (ExtensionModelHelper)this.extensionModelHelper);
        MatcherAssert.assertThat((Object)((DslElementSyntax)componentGenerationInformationDTO.getSyntax().get()), (Matcher)Matchers.is((Object)paramSyntax));
    }
}

