/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.util;

import static org.mule.runtime.ast.internal.dsl.DslConstants.CORE_NAMESPACE;

import org.mule.runtime.api.component.ComponentIdentifier;


/**
 * Utility class with common DSL-related logic.
 *
 * @since 1.3
 */
public final class DslUtils {

  /**
   * @param componentIdentifier The {@link ComponentIdentifier} to check.
   * @return Whether a given {@link ComponentIdentifier} corresponds with a sub-flow element.
   */
  public static boolean isSubflow(ComponentIdentifier componentIdentifier) {
    return componentIdentifier != null &&
        CORE_NAMESPACE.equals(componentIdentifier.getNamespaceUri()) &&
        "sub-flow".equals(componentIdentifier.getName());
  }

  private DslUtils() {
    // Private constructor to avoid instantiation
  }
}
