/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Objects;

/**
 * This is a serializable bit of information related to a DTO. It's purpose are to be serializable and, on deserialization, to be
 * used to resolve the original {@link org.mule.runtime.api.meta.model.ExtensionModel}.
 */
public class ExtensionModelDTO {

  private final String name;

  public ExtensionModelDTO(String name) {
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtensionModelDTO that = (ExtensionModelDTO) o;
    return Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name);
  }

  @Override
  public String toString() {
    return "ExtensionModelDTO{" + "name='" + name + '\'' + '}';
  }
}
