/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import static java.util.Optional.empty;
import static org.mule.runtime.api.meta.model.ComponentVisibility.PUBLIC;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DummyConstructModel implements ConstructModel {

  private final ArrayList<ParameterGroupModel> parameterGroupModels;
  private final String name;

  public DummyConstructModel(String name, ArrayList<ParameterGroupModel> parameterGroupModels) {
    this.name = name;
    this.parameterGroupModels = parameterGroupModels;
  }

  @Override
  public boolean allowsTopLevelDeclaration() {
    return false;
  }

  @Override
  public List<? extends NestableElementModel> getNestedComponents() {
    return new ArrayList<>();
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return new HashSet<>();
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public Set<ErrorModel> getErrorModels() {
    return new HashSet<>();
  }

  @Override
  public List<ParameterGroupModel> getParameterGroupModels() {
    return parameterGroupModels;
  }

  @Override
  public String getDescription() {
    return "Dummy construct model";
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public StereotypeModel getStereotype() {
    return new StereotypeModel() {

      @Override
      public String getType() {
        return "";
      }

      @Override
      public String getNamespace() {
        return "";
      }

      @Override
      public Optional<StereotypeModel> getParent() {
        return empty();
      }

      @Override
      public boolean isAssignableTo(StereotypeModel stereotypeModel) {
        return false;
      }
    };
  }

  @Override
  public ComponentVisibility getVisibility() {
    return PUBLIC;
  }

  @Override
  public Optional<MuleVersion> getMinMuleVersion() {
    return empty();
  }
}
