/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal.serialization.json;

import static java.util.Arrays.asList;
import static java.util.Collections.unmodifiableList;

import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFormat;

import java.util.List;
import java.util.concurrent.Executor;

import com.google.gson.GsonBuilder;

public class JsonArtifactAstSerializerFormat implements ArtifactAstSerializerFormat {

  public static final String JSON = "JSON";
  public static final String V_1_0 = "1.0";
  public static final String V_1_1 = "1.1";
  private static final List<String> VERSIONS = unmodifiableList(asList(V_1_0, V_1_1));

  @Override
  public String getId() {
    return JSON;
  }

  @Override
  public JsonArtifactAstSerializer createSerializer(String version, Executor executor) {
    return new JsonArtifactAstSerializer(executor, version);
  }

  @Override
  public JsonArtifactAstDeserializer createDeserializer(String version, boolean populateGenerationInformation) {
    return new JsonArtifactAstDeserializer(new GsonBuilder(), version, populateGenerationInformation);
  }

  @Override
  public List<String> getAvailableVersions() {
    return VERSIONS;
  }

  @Override
  public String getLatestVersion() {
    return VERSIONS.get(VERSIONS.size() - 1);
  }
}
