/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.testobjects;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import static java.util.Optional.empty;

public class DummyParameterModel implements ParameterModel {

  private final String name;

  public DummyParameterModel() {
    this("parameter model default name");
  }

  public DummyParameterModel(String name) {
    this.name = name;
  }

  @Override
  public boolean isRequired() {
    return false;
  }

  @Override
  public boolean isOverrideFromConfig() {
    return false;
  }

  @Override
  public ExpressionSupport getExpressionSupport() {
    return null;
  }

  @Override
  public Object getDefaultValue() {
    return null;
  }

  @Override
  public ParameterDslConfiguration getDslConfiguration() {
    return null;
  }

  @Override
  public ParameterRole getRole() {
    return ParameterRole.BEHAVIOUR;
  }

  @Override
  public Optional<LayoutModel> getLayoutModel() {
    return empty();
  }

  @Override
  public List<StereotypeModel> getAllowedStereotypes() {
    return new ArrayList<>();
  }

  @Override
  public Optional<ValueProviderModel> getValueProviderModel() {
    return empty();
  }

  @Override
  public List<FieldValueProviderModel> getFieldValueProviderModels() {
    return new ArrayList<>();
  }

  @Override
  public boolean isComponentId() {
    return name.equals("name");
  }

  @Override
  public String getDescription() {
    return null;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public MetadataType getType() {
    MetadataFormat metadataFormat = MetadataFormat.XML;
    Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions = new HashMap<>();
    return new DefaultStringType(metadataFormat, extensions);
  }

  @Override
  public boolean hasDynamicType() {
    return false;
  }

  @Override
  public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> aClass) {
    return empty();
  }

  @Override
  public Set<ModelProperty> getModelProperties() {
    return new HashSet<>();
  }

  @Override
  public Optional<DeprecationModel> getDeprecationModel() {
    return empty();
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return empty();
  }

  @Override
  public Optional<MuleVersion> getMinMuleVersion() {
    return empty();
  }
}
