/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.api.serialization;

import static org.mule.runtime.ast.AllureConstants.ArtifactAstSerialization.AST_SERIALIZATION;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFactory;
import org.mule.runtime.ast.internal.serialization.DefaultArtifactAstDeserializer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.junit.Before;
import org.junit.Test;

import io.qameta.allure.Feature;

@Feature(AST_SERIALIZATION)
public class ArtifactAstSerializerProviderTestCase {

  private ArtifactAstSerializerProvider artifactAstSerializerProvider;
  private ArtifactAstSerializerFactory artifactAstSerializerFactory;

  @Before
  public void setUp() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException,
      NoSuchMethodException, SecurityException {
    artifactAstSerializerFactory = mock(ArtifactAstSerializerFactory.class);

    Constructor<ArtifactAstSerializerProvider> serializerConstructor =
        ArtifactAstSerializerProvider.class.getDeclaredConstructor(ArtifactAstSerializerFactory.class);
    serializerConstructor.setAccessible(true);
    artifactAstSerializerProvider = serializerConstructor
        .newInstance(artifactAstSerializerFactory);
  }

  @Test
  public void testGetSerializerCallsSerializerFactoryGetSerializerWithJSONParam_WhenGettingAJsonSerializer() {
    // Given
    String format = "JSON";

    // When
    artifactAstSerializerProvider.getSerializer(format, "1.0");

    // Then
    verify(artifactAstSerializerFactory, times(1)).getSerializer(format, "1.0");
  }

  @Test
  public void testGetSerializerCallsSerializerFactoryGetSerializerWithKlingonParam_WhenGettingAKlingonSerializer() {
    // Given
    String format = "Klingon";

    // When
    artifactAstSerializerProvider.getSerializer(format, "1.0");

    // Then
    verify(artifactAstSerializerFactory, times(1)).getSerializer(format, "1.0");
  }

  @Test
  public void testGetDeserializerReturnsDefaultArtifactAstDeserializerInstance_WhenGettingADeserializer() {
    // Given

    // When
    ArtifactAstDeserializer deserializer = artifactAstSerializerProvider.getDeserializer();

    // Then
    assertThat(deserializer, instanceOf(DefaultArtifactAstDeserializer.class));
  }

}
