/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.testobjects;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.ExtensionConstants;

public class DummyExtensionModel
implements ExtensionModel {
    private final List<SourceModel> sourceModels;
    private final List<ConstructModel> constructModels;
    private final XmlDslModel dslModel;
    private final String name;
    private final List<OperationModel> operationModels;
    private final List<ConfigurationModel> configurationModels;
    private final List<ConnectionProviderModel> connectionProviderModels;

    public DummyExtensionModel() {
        this("extension model default name");
    }

    public DummyExtensionModel(String name) {
        this(name, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public DummyExtensionModel(String name, List<OperationModel> operationModels, List<ConfigurationModel> configurationModels, List<SourceModel> sourceModels, List<ConstructModel> constructModels, List<ConnectionProviderModel> connectionProviderModels) {
        this.name = name;
        this.dslModel = XmlDslModel.builder().setPrefix(name).build();
        this.operationModels = operationModels;
        this.configurationModels = configurationModels;
        this.sourceModels = sourceModels;
        this.constructModels = constructModels;
        this.connectionProviderModels = connectionProviderModels;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return null;
    }

    public List<ConfigurationModel> getConfigurationModels() {
        return this.configurationModels;
    }

    public Optional<ConfigurationModel> getConfigurationModel(String name) {
        return this.configurationModels.stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public List<OperationModel> getOperationModels() {
        return this.operationModels;
    }

    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.connectionProviderModels;
    }

    public List<SourceModel> getSourceModels() {
        return this.sourceModels;
    }

    public Set<ObjectType> getTypes() {
        return Collections.emptySet();
    }

    public Set<String> getResources() {
        return Collections.emptySet();
    }

    public Set<String> getPrivilegedPackages() {
        return Collections.emptySet();
    }

    public Set<String> getPrivilegedArtifacts() {
        return Collections.emptySet();
    }

    public String getVendor() {
        return "dummy vendor";
    }

    public Category getCategory() {
        return null;
    }

    public XmlDslModel getXmlDslModel() {
        return this.dslModel;
    }

    public Set<SubTypesModel> getSubTypes() {
        return Collections.emptySet();
    }

    public Set<ImportedTypeModel> getImportedTypes() {
        return Collections.emptySet();
    }

    public Set<ErrorModel> getErrorModels() {
        return Collections.emptySet();
    }

    public Set<NotificationModel> getNotificationModels() {
        return Collections.emptySet();
    }

    public Optional<ComponentModel> findComponentModel(String componentName) {
        return Optional.empty();
    }

    public Optional<ArtifactCoordinates> getArtifactCoordinates() {
        return Optional.empty();
    }

    public String getDescription() {
        return "A dummy extension model for testing";
    }

    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        return Optional.empty();
    }

    public Set<ModelProperty> getModelProperties() {
        return Collections.emptySet();
    }

    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return Collections.emptySet();
    }

    public Optional<ConnectionProviderModel> getConnectionProviderModel(String name) {
        return this.getConnectionProviders().stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public List<ConstructModel> getConstructModels() {
        return this.constructModels;
    }

    public Optional<ConstructModel> getConstructModel(String name) {
        return this.getConstructModels().stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.empty();
    }

    public List<FunctionModel> getFunctionModels() {
        return Collections.emptyList();
    }

    public Optional<FunctionModel> getFunctionModel(String name) {
        return Optional.empty();
    }

    public Optional<OperationModel> getOperationModel(String name) {
        return this.getOperationModels().stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public Optional<SourceModel> getSourceModel(String name) {
        return this.getSourceModels().stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.empty();
    }

    public Set<String> getSupportedJavaVersions() {
        return ExtensionConstants.DEFAULT_SUPPORTED_JAVA_VERSIONS;
    }
}

