/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto.factory;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ComponentMetadataAstDTOFactoryTestCase {
    private AstDTOFactoryProvider astDTOFactoryProvider;
    private ComponentMetadataAst componentMetadataAst;
    private Optional<String> fileName;
    private Optional<URI> fileUri;
    private List<ImportedResource> importChain;
    private OptionalInt startLine;
    private OptionalInt startColumn;
    private OptionalInt endLine;
    private OptionalInt endColumn;
    private Optional<String> sourceCode;
    private Map<String, String> docAttributes;
    private Map<String, Object> parserAttributes;

    @Before
    public void setUp() throws Exception {
        this.astDTOFactoryProvider = new AstDTOFactoryProvider(new ArtifactAstSerializerMetadata("JSON", "1.0", StandardCharsets.UTF_8));
        this.fileName = Optional.empty();
        this.importChain = Collections.emptyList();
        this.fileUri = Optional.empty();
        this.startLine = OptionalInt.empty();
        this.startColumn = OptionalInt.empty();
        this.endLine = OptionalInt.empty();
        this.endColumn = OptionalInt.empty();
        this.sourceCode = Optional.empty();
        this.docAttributes = null;
        this.parserAttributes = null;
        this.componentMetadataAst = new TestComponentMetadataAst();
    }

    @Test
    public void testBuildReturnsMetadataDTOWithSameAttributesAsTheInput_WhenBuildingFromMetadataInputWithSetAttributes() {
        this.fileName = Optional.of("some file name");
        URI rootConfigUri = URI.create("file:///some/file/rootConfig.xml");
        ImportedResourceDTO importedResourceInChain = new ImportedResourceDTO("some file name", new ComponentMetadataAstDTO(null, null, null, "root config", rootConfigUri, Collections.emptyList(), null, null, null, null), null);
        importedResourceInChain.setPropertiesResolver(new PropertiesResolver());
        this.importChain = Collections.singletonList(importedResourceInChain);
        this.fileUri = Optional.of(URI.create("file:///some/file/path.xml"));
        this.startLine = OptionalInt.of(4);
        this.startColumn = OptionalInt.of(2345);
        this.endLine = OptionalInt.of(96);
        this.endColumn = OptionalInt.of(3478);
        this.sourceCode = Optional.of("while(1){continue;}");
        this.docAttributes = new HashMap<String, String>();
        this.docAttributes.put("onekey", "onevalue");
        this.docAttributes.put("twokey", "twovalue");
        this.parserAttributes = new HashMap<String, Object>();
        this.parserAttributes.put("somekey", new Object());
        this.parserAttributes.put("someotherkey", new Object());
        ComponentMetadataAstDTO componentMetadataAstDTO = this.astDTOFactoryProvider.getComponentMetadataAstDTOFactory().from(this.componentMetadataAst);
        componentMetadataAstDTO.enrich(Collections.singletonMap("some file name", importedResourceInChain));
        componentMetadataAstDTO.setPropertiesResolver(new PropertiesResolver());
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getFileName(), (Matcher)Matchers.is(this.fileName));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getImportChain(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ImportedResource importChain_0 = (ImportedResource)componentMetadataAstDTO.getImportChain().get(0);
        MatcherAssert.assertThat((Object)importChain_0.getResourceLocation(), (Matcher)Matchers.is((Object)"some file name"));
        MatcherAssert.assertThat((Object)((String)importChain_0.getMetadata().getFileName().get()), (Matcher)Matchers.is((Object)"root config"));
        MatcherAssert.assertThat((Object)((URI)importChain_0.getMetadata().getFileUri().get()), (Matcher)Matchers.is((Object)rootConfigUri));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getStartLine(), (Matcher)Matchers.is((Object)this.startLine));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getStartColumn(), (Matcher)Matchers.is((Object)this.startColumn));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getEndLine(), (Matcher)Matchers.is((Object)this.endLine));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getEndColumn(), (Matcher)Matchers.is((Object)this.endColumn));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getSourceCode(), (Matcher)Matchers.is(this.sourceCode));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getDocAttributes(), (Matcher)Matchers.is(this.docAttributes));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getParserAttributes(), (Matcher)Matchers.is(this.parserAttributes));
    }

    @Test
    public void testBuildReturnsMetadataDTOWithSameAttributesAsTheInput_WhenBuildingFromMetadataInputWithNotSetAttributes() {
        ComponentMetadataAstDTO componentMetadataAstDTO = this.astDTOFactoryProvider.getComponentMetadataAstDTOFactory().from(this.componentMetadataAst);
        componentMetadataAstDTO.enrich(Collections.emptyMap());
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getFileName(), (Matcher)Matchers.is(this.fileName));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getImportChain(), (Matcher)Matchers.is(this.importChain));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getStartLine(), (Matcher)Matchers.is((Object)this.startLine));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getStartColumn(), (Matcher)Matchers.is((Object)this.startColumn));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getEndLine(), (Matcher)Matchers.is((Object)this.endLine));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getEndColumn(), (Matcher)Matchers.is((Object)this.endColumn));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getSourceCode(), (Matcher)Matchers.is(this.sourceCode));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getDocAttributes(), (Matcher)Matchers.is(this.docAttributes));
        MatcherAssert.assertThat((Object)componentMetadataAstDTO.getParserAttributes(), (Matcher)Matchers.is(this.parserAttributes));
    }

    private class TestComponentMetadataAst
    implements ComponentMetadataAst {
        private TestComponentMetadataAst() {
        }

        public Optional<String> getFileName() {
            return ComponentMetadataAstDTOFactoryTestCase.this.fileName;
        }

        public Optional<URI> getFileUri() {
            return ComponentMetadataAstDTOFactoryTestCase.this.fileUri;
        }

        public List<ImportedResource> getImportChain() {
            return ComponentMetadataAstDTOFactoryTestCase.this.importChain;
        }

        public OptionalInt getStartLine() {
            return ComponentMetadataAstDTOFactoryTestCase.this.startLine;
        }

        public OptionalInt getStartColumn() {
            return ComponentMetadataAstDTOFactoryTestCase.this.startColumn;
        }

        public OptionalInt getEndLine() {
            return ComponentMetadataAstDTOFactoryTestCase.this.endLine;
        }

        public OptionalInt getEndColumn() {
            return ComponentMetadataAstDTOFactoryTestCase.this.endColumn;
        }

        public Optional<String> getSourceCode() {
            return ComponentMetadataAstDTOFactoryTestCase.this.sourceCode;
        }

        public Map<String, String> getDocAttributes() {
            return ComponentMetadataAstDTOFactoryTestCase.this.docAttributes;
        }

        public Map<String, Object> getParserAttributes() {
            return ComponentMetadataAstDTOFactoryTestCase.this.parserAttributes;
        }
    }
}

