/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;

@Feature(value="AST serialization")
@Story(value="AST serialization enrichment")
public class ComponentParameterAstDTOTestCase {
    private ParameterModel paramModel;
    private ParameterGroupModel paramGroupModel;

    @Before
    public void before() {
        this.paramModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.paramModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        this.paramGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
    }

    @Test
    public void expressionWithPadding() {
        ComponentParameterAstDTO param = new ComponentParameterAstDTO(null, "    #[anExpression]\r\n", false, (ComponentMetadataAstDTO)Mockito.mock(ComponentMetadataAstDTO.class), "General", "expressionValue");
        param.setModel(this.paramModel, this.paramGroupModel);
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        param.setPropertiesResolver(propertiesResolver);
        MatcherAssert.assertThat((Object)((String)param.getValue().getLeft()), (Matcher)Is.is((Object)"anExpression"));
    }

    @Test
    @Issue(value="MULE-19822")
    public void expressionwithPropertyPlaceholders() {
        ComponentParameterAstDTO param = new ComponentParameterAstDTO(null, "#[${aProperty}]", false, (ComponentMetadataAstDTO)Mockito.mock(ComponentMetadataAstDTO.class), "General", "expressionValue");
        param.setModel(this.paramModel, this.paramGroupModel);
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        param.setPropertiesResolver(propertiesResolver);
        propertiesResolver.setMappingFunction(p -> {
            if (p.equals("#[${aProperty}]")) {
                return "#[anExpression]";
            }
            return p;
        });
        MatcherAssert.assertThat((Object)((String)param.getValue().getLeft()), (Matcher)Is.is((Object)"anExpression"));
    }
}

