/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.test.internal.serialization.dto.factory;

import com.google.common.collect.Sets;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ErrorTypeRepositoryDTO;
import org.mule.runtime.ast.internal.serialization.dto.ExtensionModelDTO;
import org.mule.runtime.ast.internal.serialization.dto.factory.ArtifactAstDTOFactory;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.ast.internal.serialization.dto.factory.ComponentAstDTOFactory;
import org.mule.runtime.ast.internal.serialization.dto.factory.ErrorTypeRepositoryDTOFactory;
import org.mule.runtime.ast.internal.serialization.dto.factory.ExtensionModelDTOFactory;
import org.mule.runtime.ast.internal.serialization.resolver.DefaultGenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.testobjects.DummyExtensionModel;
import org.mule.runtime.ast.testobjects.TestArtifactAstFactory;
import org.mule.runtime.ast.testobjects.TestExtensionModelResolver;

@Feature(value="AST serialization")
@Story(value="AST serializable representation")
public class ArtifactAstDTOFactoryTestCase {
    private TestArtifactAstFactory testArtifactAstFactory;
    private AstDTOFactoryProvider astDTOFactoryProvider;
    private ArtifactAstDTOFactory innerArtifactAstDTOFactory;
    private ExtensionModelDTOFactory extensionModelDTOFactory;
    private ComponentAstDTOFactory componentAstDTOFactory;
    private ArtifactAstDTOFactory artifactAstDTOFactory;
    private ErrorTypeRepositoryDTOFactory errorRepositoryDTOBuilder;
    private DummyExtensionModel coreExtModel;
    private DummyExtensionModel dummyExtensionModel;
    private Set<ExtensionModel> extModels;
    private DefaultGenerationInformationResolver generationInformationResolver;
    private TestExtensionModelResolver extensionModelResolver;

    @Before
    public void setUp() throws Exception {
        this.testArtifactAstFactory = new TestArtifactAstFactory();
        this.innerArtifactAstDTOFactory = (ArtifactAstDTOFactory)Mockito.mock(ArtifactAstDTOFactory.class);
        this.extensionModelDTOFactory = (ExtensionModelDTOFactory)Mockito.mock(ExtensionModelDTOFactory.class);
        this.componentAstDTOFactory = (ComponentAstDTOFactory)Mockito.mock(ComponentAstDTOFactory.class);
        this.errorRepositoryDTOBuilder = (ErrorTypeRepositoryDTOFactory)Mockito.mock(ErrorTypeRepositoryDTOFactory.class);
        this.astDTOFactoryProvider = new TestAstDTOFactoryProvider();
        this.artifactAstDTOFactory = new ArtifactAstDTOFactory(this.astDTOFactoryProvider);
        this.coreExtModel = new DummyExtensionModel("mule");
        this.dummyExtensionModel = new DummyExtensionModel("Dummy name");
        this.extModels = Sets.newHashSet((Object[])new ExtensionModel[]{this.coreExtModel, this.dummyExtensionModel});
        this.extensionModelResolver = new TestExtensionModelResolver(this.extModels);
        this.generationInformationResolver = new DefaultGenerationInformationResolver();
    }

    @Test
    public void testFromArtifactAstDTOReturnsADTOWithTheCorrectAmountOfTopLevelComponentsAndImportedResources_WhenCreatingADTOFromAnArtifactAST() {
        AstDTOFactoryProvider astDTOFactoryProvider = new AstDTOFactoryProvider(new ArtifactAstSerializerMetadata("JSON", "1.0", StandardCharsets.UTF_8));
        ArtifactAstDTOFactory artifactAstDTOFactory = new ArtifactAstDTOFactory(astDTOFactoryProvider);
        ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        String extensionModelName = "some extension model name";
        Mockito.when((Object)extensionModel.getName()).thenReturn((Object)extensionModelName);
        Mockito.when((Object)artifactAst.dependencies()).thenReturn((Object)Sets.newHashSet((Object[])new ExtensionModel[]{extensionModel}));
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)componentAst.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.UNKNOWN);
        Mockito.when((Object)componentAst.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)artifactAst.topLevelComponents()).thenReturn(Collections.singletonList(componentAst));
        Mockito.when((Object)artifactAst.topLevelComponentsStream()).thenReturn(Stream.of(componentAst));
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)artifactAst.getErrorTypeRepository()).thenReturn((Object)errorTypeRepository);
        ArtifactAst parentArtifact = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Optional<ArtifactAst> optionalParentArtifactAst = Optional.of(parentArtifact);
        Mockito.when((Object)parentArtifact.getErrorTypeRepository()).thenReturn((Object)errorTypeRepository);
        Mockito.when((Object)artifactAst.getParent()).thenReturn(optionalParentArtifactAst);
        ArtifactAstDTO artifactAstDTO = artifactAstDTOFactory.from(artifactAst);
        MatcherAssert.assertThat((Object)artifactAstDTO.topLevelComponents().size(), (Matcher)Matchers.is((Object)artifactAst.topLevelComponents().size()));
        MatcherAssert.assertThat((Object)artifactAstDTO.getImportedResources().size(), (Matcher)Matchers.is((Object)artifactAst.getImportedResources().size()));
        MatcherAssert.assertThat((Object)artifactAstDTO.getParent(), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testMappingSimpleHttpApp() {
        ArtifactAst simpleHttpArtifact = this.testArtifactAstFactory.createArtifactFromXmlFile("test-apps/http-listener-with-logger.xml", this.extModels);
        Mockito.when((Object)this.innerArtifactAstDTOFactory.from((ArtifactAst)ArgumentMatchers.any(ArtifactAst.class))).thenReturn((Object)((ArtifactAstDTO)Mockito.mock(ArtifactAstDTO.class)));
        ExtensionModelDTO immutableExtensionModelDto = (ExtensionModelDTO)Mockito.mock(ExtensionModelDTO.class);
        Mockito.when((Object)immutableExtensionModelDto.getName()).thenReturn((Object)"mule");
        ExtensionModelDTO dummyExtensionModelDTO = (ExtensionModelDTO)Mockito.mock(ExtensionModelDTO.class);
        Mockito.when((Object)dummyExtensionModelDTO.getName()).thenReturn((Object)"Dummy name");
        Mockito.when((Object)this.extensionModelDTOFactory.from((ExtensionModel)ArgumentMatchers.any(ExtensionModel.class))).thenReturn((Object)immutableExtensionModelDto, (Object[])new ExtensionModelDTO[]{dummyExtensionModelDTO});
        Mockito.when((Object)this.componentAstDTOFactory.from((ComponentAst)ArgumentMatchers.any(ComponentAst.class))).thenReturn((Object)((ComponentAstDTO)Mockito.mock(ComponentAstDTO.class)));
        Mockito.when((Object)this.errorRepositoryDTOBuilder.from((ErrorTypeRepository)ArgumentMatchers.any(ErrorTypeRepository.class))).thenReturn((Object)((ErrorTypeRepositoryDTO)Mockito.mock(ErrorTypeRepositoryDTO.class)));
        ArtifactAstDTO artifactAstDTO = this.artifactAstDTOFactory.from(simpleHttpArtifact);
        artifactAstDTO.enrich((ExtensionModelResolver)this.extensionModelResolver, (GenerationInformationResolver)this.generationInformationResolver);
        ((ArtifactAstDTOFactory)Mockito.verify((Object)this.innerArtifactAstDTOFactory, (VerificationMode)Mockito.never())).from((ArtifactAst)ArgumentMatchers.any(ArtifactAst.class));
        MatcherAssert.assertThat((Object)artifactAstDTO.dependencies().size(), (Matcher)Matchers.is((Object)simpleHttpArtifact.dependencies().stream().map(ExtensionModel::getName).collect(Collectors.toSet()).size()));
        ((ExtensionModelDTOFactory)Mockito.verify((Object)this.extensionModelDTOFactory, (VerificationMode)Mockito.times((int)1))).from((ExtensionModel)this.coreExtModel);
        ((ExtensionModelDTOFactory)Mockito.verify((Object)this.extensionModelDTOFactory, (VerificationMode)Mockito.times((int)1))).from((ExtensionModel)this.dummyExtensionModel);
        InOrder inOrderComponentAst = Mockito.inOrder((Object[])new Object[]{this.componentAstDTOFactory, this.componentAstDTOFactory});
        ((ComponentAstDTOFactory)inOrderComponentAst.verify((Object)this.componentAstDTOFactory, Mockito.times((int)2))).from((ComponentAst)ArgumentMatchers.any(ComponentAst.class));
        ((ErrorTypeRepositoryDTOFactory)Mockito.verify((Object)this.errorRepositoryDTOBuilder, (VerificationMode)Mockito.times((int)1))).from(simpleHttpArtifact.getErrorTypeRepository());
        MatcherAssert.assertThat((Object)artifactAstDTO.topLevelComponentsStream().count(), (Matcher)Matchers.is((Object)simpleHttpArtifact.topLevelComponentsStream().count()));
        MatcherAssert.assertThat((Object)artifactAstDTO.getParent(), (Matcher)Matchers.is((Object)simpleHttpArtifact.getParent()));
    }

    @Test
    @Issue(value="MULE-19836")
    public void importTagUsingProperty() {
        ImportedResource imported = (ImportedResource)Mockito.mock(ImportedResource.class);
        Mockito.when((Object)imported.getRawResourceLocation()).thenReturn((Object)"${someProperty}.xml");
        Mockito.when((Object)imported.getResourceLocation()).thenReturn((Object)"resolved.xml");
        Mockito.when((Object)imported.getMetadata()).thenReturn((Object)((ComponentMetadataAst)Mockito.mock(ComponentMetadataAst.class)));
        ArtifactAst artifact = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)artifact.getImportedResources()).thenReturn(Collections.singleton(imported));
        ArtifactAstDTO artifactAstDTO = this.artifactAstDTOFactory.from(artifact);
        ImportedResource importedDto = (ImportedResource)artifactAstDTO.getImportedResources().iterator().next();
        MatcherAssert.assertThat((Object)importedDto.getRawResourceLocation(), (Matcher)Matchers.is((Object)"${someProperty}.xml"));
    }

    private class TestAstDTOFactoryProvider
    extends AstDTOFactoryProvider {
        private TestAstDTOFactoryProvider() {
            super(new ArtifactAstSerializerMetadata("JSON", "1.0", StandardCharsets.UTF_8));
        }

        public ArtifactAstDTOFactory getArtifactAstDTOFactory() {
            return ArtifactAstDTOFactoryTestCase.this.innerArtifactAstDTOFactory;
        }

        public ExtensionModelDTOFactory getExtensionModelDTOFactory() {
            return ArtifactAstDTOFactoryTestCase.this.extensionModelDTOFactory;
        }

        public ComponentAstDTOFactory getComponentAstDTOFactory() {
            return ArtifactAstDTOFactoryTestCase.this.componentAstDTOFactory;
        }

        public ErrorTypeRepositoryDTOFactory getErrorRepositoryDTOFactory() {
            return ArtifactAstDTOFactoryTestCase.this.errorRepositoryDTOBuilder;
        }
    }
}

