/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonDeserializer;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationJsonDeserializer
implements JsonDeserializer<ComponentLocation> {
    public ComponentLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        List importChain;
        ComponentIdentifierJsonDeserializer componentIdentifierJsonDeserializer = new ComponentIdentifierJsonDeserializer();
        JsonObject locationJsonObject = jsonElement.getAsJsonObject();
        JsonElement nameJsonElement = locationJsonObject.get("name");
        Optional name = nameJsonElement != null ? Optional.of(nameJsonElement.getAsString()) : Optional.empty();
        JsonArray jsonArray = locationJsonObject.get("parts").getAsJsonArray();
        ArrayList<DefaultComponentLocation.DefaultLocationPart> parts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        for (JsonElement element : jsonArray) {
            Optional<Object> partIdentifier = Optional.empty();
            JsonObject locationPartJsonObject = element.getAsJsonObject();
            JsonElement partPathJsonElement = locationPartJsonObject.get("partPath");
            String partPath = partPathJsonElement != null ? partPathJsonElement.getAsString() : null;
            JsonElement partIdentifierJsonElement = locationPartJsonObject.get("partIdentifier");
            if (partIdentifierJsonElement != null) {
                JsonObject locationPartIdentifierJsonObject = partIdentifierJsonElement.getAsJsonObject();
                JsonElement identifier = locationPartIdentifierJsonObject.get("identifier");
                JsonElement componentType = locationPartIdentifierJsonObject.get("type");
                partIdentifier = Optional.ofNullable(identifier != null ? TypedComponentIdentifier.builder().identifier(componentIdentifierJsonDeserializer.deserialize(identifier, (Type)((Object)ComponentIdentifier.class), jsonDeserializationContext)).type(TypedComponentIdentifier.ComponentType.valueOf((String)componentType.getAsJsonObject().get("name").getAsString())).build() : null);
            }
            Optional<Object> fileName = Optional.ofNullable(locationPartJsonObject.get("fileName") != null ? locationPartJsonObject.get("fileName").getAsString() : null);
            OptionalInt lineInFile = OptionalInt.empty();
            JsonElement lineInFileJsonElement = locationPartJsonObject.get("line");
            if (lineInFileJsonElement != null) {
                lineInFile = OptionalInt.of(lineInFileJsonElement.getAsInt());
            }
            OptionalInt startColumn = OptionalInt.empty();
            JsonElement startColumnJsonElement = locationPartJsonObject.get("column");
            if (startColumnJsonElement != null) {
                startColumn = OptionalInt.of(startColumnJsonElement.getAsInt());
            }
            parts.add(new DefaultComponentLocation.DefaultLocationPart(partPath, partIdentifier, fileName, lineInFile, startColumn));
        }
        if (locationJsonObject.get("importChain") != null) {
            importChain = new ArrayList();
            for (JsonElement importChainItem : locationJsonObject.get("importChain").getAsJsonArray()) {
                importChain.add(URI.create(importChainItem.getAsString()));
            }
        } else {
            importChain = Collections.emptyList();
        }
        return new DefaultComponentLocation(name, parts, importChain);
    }
}

