/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;

public class ArtifactAstSerializerMetadataSerializer {
    private static final long MAX_HEADER_LINE_LENGTH = 1002L;
    public static final String DELIMITER = "#";
    public static final String HEADER_REGEX = "^([^#]+)[#]([^#]+)[#]$";
    private final Pattern headerRegexPattern = Pattern.compile("^([^#]+)[#]([^#]+)[#]$");

    public ArtifactAstSerializerMetadata readArtifactAstSerializerMetadataFromInputStream(InputStream inputStream) throws IOException {
        BoundedInputStream boundedInputStream = new BoundedInputStream(inputStream, 1002L);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)boundedInputStream));
        String headerString = bufferedReader.readLine();
        Matcher matcher = this.headerRegexPattern.matcher(headerString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The serialized artifact input stream has an invalid header.");
        }
        return new ArtifactAstSerializerMetadata(matcher.group(1), matcher.group(2));
    }

    public InputStream addArtifactAstSerializerMetadataToInputStream(InputStream inputStream, ArtifactAstSerializerMetadata artifactAstSerializerMetadata) {
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(artifactAstSerializerMetadata, "artifactAstSerializerMetadata");
        String headerString = artifactAstSerializerMetadata.getSerializerId() + DELIMITER + artifactAstSerializerMetadata.getSerializerVersion() + DELIMITER + System.lineSeparator();
        InputStream headerInputStream = IOUtils.toInputStream((String)headerString, (Charset)StandardCharsets.UTF_8);
        return new SequenceInputStream(headerInputStream, inputStream);
    }
}

