/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import io.qameta.allure.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadata;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerMetadataSerializer;

@Feature(value="AST metadata serialization")
public class ArtifactAstSerializerMetadataSerializerTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ArtifactAstSerializerMetadataSerializer artifactAstSerializerMetadataSerializer;

    @Before
    public void setUp() {
        this.artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
    }

    @Test
    public void testReadMetadataReturnsSerializedMetadataWithIDJsonVersion100_WhenReadingAnArtifactAstInputStreamSerializedWithJsonSerializer100() throws IOException {
        String serializerId = "JSON";
        String serializerVersion = "1.0.0";
        String jsonBody = "{{{{{{{{{{}}}}}}}}}}";
        InputStream inputStream = IOUtils.toInputStream((String)(serializerId + "#" + serializerVersion + "#" + System.lineSeparator() + jsonBody), (Charset)StandardCharsets.UTF_8);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream);
        MatcherAssert.assertThat((Object)artifactAstSerializerMetadata.getSerializerId(), (Matcher)Matchers.is((Object)serializerId));
        MatcherAssert.assertThat((Object)artifactAstSerializerMetadata.getSerializerVersion(), (Matcher)Matchers.is((Object)serializerVersion));
    }

    @Test
    public void testReadMetadataReturnsSerializedMetadataWithIDKlingonVersion123_WhenReadingAnArtifactAstInputStreamSerializedWithKlingonSerializer123() throws IOException {
        String serializerId = "KLINGON";
        String serializerVersion = "1.2.3";
        String jsonBody = "{{{{{{{{{{}}}}}}}}}}";
        InputStream inputStream = IOUtils.toInputStream((String)(serializerId + "#" + serializerVersion + "#" + System.lineSeparator() + jsonBody), (Charset)StandardCharsets.UTF_8);
        this.artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream);
        MatcherAssert.assertThat((Object)artifactAstSerializerMetadata.getSerializerId(), (Matcher)Matchers.is((Object)serializerId));
        MatcherAssert.assertThat((Object)artifactAstSerializerMetadata.getSerializerVersion(), (Matcher)Matchers.is((Object)serializerVersion));
    }

    @Test
    public void testReadMetadataThrowsIllegalArgumentException_WhenReadingAnArtifactAstInputStreamWithAnInvalidHeaderThatHasWayTooLongSerializerId() throws IOException {
        String serializerId = "ThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLongThisIdIsWayTooLong";
        String serializerVersion = "1.2.3";
        String jsonBody = "{{{{{{{{{{}}}}}}}}}}";
        InputStream inputStream = IOUtils.toInputStream((String)(serializerId + "#" + serializerVersion + "#" + System.lineSeparator() + jsonBody), (Charset)StandardCharsets.UTF_8);
        this.artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The serialized artifact input stream has an invalid header.");
        this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream);
    }

    @Test
    public void testReadMetadataThrowsIllegalArgumentException_WhenReadingAnArtifactAstInputStreamWithAnInvalidHeaderThatHasNoDelimiters() throws IOException {
        String serializerId = "SomeOtherId";
        String serializerVersion = "1.2.3";
        String jsonBody = "{{{{{{{{{{}}}}}}}}}}";
        InputStream inputStream = IOUtils.toInputStream((String)(serializerId + serializerVersion + System.lineSeparator() + jsonBody), (Charset)StandardCharsets.UTF_8);
        this.artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The serialized artifact input stream has an invalid header.");
        this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream);
    }

    @Test
    public void testReadMetadataThrowsIllegalArgumentException_WhenReadingAnArtifactAstInputStreamWithNoHeader() throws IOException {
        String jsonBody = "{{{{{{{{{{}}}}}}}}}}";
        InputStream inputStream = IOUtils.toInputStream((String)jsonBody, (Charset)StandardCharsets.UTF_8);
        this.artifactAstSerializerMetadataSerializer = new ArtifactAstSerializerMetadataSerializer();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The serialized artifact input stream has an invalid header.");
        this.artifactAstSerializerMetadataSerializer.readArtifactAstSerializerMetadataFromInputStream(inputStream);
    }

    @Test
    public void testAddHeaderToInputStreamReturnsAnInputStreamWithTheHeaderLineSomeFormat124130FollowedByTheOriginalContent_WhenAddingAHeaderToAnInputStream() throws IOException {
        String jsonBody = "{}";
        InputStream inputStream = IOUtils.toInputStream((String)jsonBody, (Charset)StandardCharsets.UTF_8);
        String serializerId = "someformat";
        String serializerVersion = "12.41.30";
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata(serializerId, serializerVersion);
        InputStream result = this.artifactAstSerializerMetadataSerializer.addArtifactAstSerializerMetadataToInputStream(inputStream, artifactAstSerializerMetadata);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)result, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)(serializerId + "#" + serializerVersion + "#\n" + jsonBody)));
    }

    @Test
    public void testAddHeaderToInputStreamReturnsAnInputStreamWithTheHeaderLineJSON100FollowedByTheOriginalContent_WhenAddingAHeaderToAnInputStream() throws IOException {
        String jsonBody = "{\"atribute\": \"Some string I guess\"}";
        InputStream inputStream = IOUtils.toInputStream((String)jsonBody, (Charset)StandardCharsets.UTF_8);
        String serializerId = "JSON";
        String serializerVersion = "1.0.0";
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata(serializerId, serializerVersion);
        InputStream result = this.artifactAstSerializerMetadataSerializer.addArtifactAstSerializerMetadataToInputStream(inputStream, artifactAstSerializerMetadata);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)result, (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)(serializerId + "#" + serializerVersion + "#\n" + jsonBody)));
    }

    @Test
    public void testAddHeaderToInputStreamThrowsNPEInputStream_WhenAddingAHeaderToANullInputStream() {
        InputStream inputStream = null;
        String serializerId = "JSON";
        String serializerVersion = "1.0.0";
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = new ArtifactAstSerializerMetadata(serializerId, serializerVersion);
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("inputStream");
        this.artifactAstSerializerMetadataSerializer.addArtifactAstSerializerMetadataToInputStream(inputStream, artifactAstSerializerMetadata);
    }

    @Test
    public void testAddHeaderToInputStreamThrowsNPEInputStream_WhenAddingANullSerializerMetadataHeaderToAnInputStream() {
        String jsonBody = "{\"atribute\": \"Lorem ipsum or something\"}";
        InputStream inputStream = IOUtils.toInputStream((String)jsonBody, (Charset)StandardCharsets.UTF_8);
        ArtifactAstSerializerMetadata artifactAstSerializerMetadata = null;
        this.exception.expect(NullPointerException.class);
        this.exception.expectMessage("artifactAstSerializerMetadata");
        this.artifactAstSerializerMetadataSerializer.addArtifactAstSerializerMetadataToInputStream(inputStream, artifactAstSerializerMetadata);
    }
}

