/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import io.qameta.allure.Feature;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.ast.internal.serialization.ArtifactAstSerializerFactory;

@Feature(value="AST serialization")
public class ArtifactAstSerializerFactoryTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ArtifactAstSerializerFactory artifactAstSerializerFactory;

    @Before
    public void setUp() {
        this.artifactAstSerializerFactory = new ArtifactAstSerializerFactory();
    }

    @Test
    public void testGetSerializerThrowsIllegalArgumentExceptionUnexistingFormat_WhenGettingSerializerForUnexistingFormat() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No serializer named 'UNEXISTING' is available. Available serializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getSerializer("UNEXISTING");
    }

    @Test
    public void testGetDeserializerThrowsIllegalArgumentExceptionUnexisting2Format_WhenGettingDeserializerForUnexisting2Format() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("No deserializer named 'UNEXISTING2' is available. Available deserializers are: [" + StringUtils.join((Iterable)this.artifactAstSerializerFactory.getAvailableSerializers(), (String)", ") + "]");
        this.artifactAstSerializerFactory.getDeserializer("UNEXISTING2");
    }
}

