/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.graph.internal;

import static java.util.stream.Stream.concat;
import static java.util.stream.Stream.of;

import org.mule.runtime.ast.api.ComponentAst;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;


public class ComponentAstEdge extends DefaultEdge {

  private static final long serialVersionUID = 7197173256937882452L;

  public Stream<ComponentAst> transitiveOutgoingDependenciesOf(Graph<ComponentAst, ComponentAstEdge> graph) {
    return doTransitiveOutgoingDependenciesOf(graph, new HashSet<>());
  }

  private Stream<ComponentAst> doTransitiveOutgoingDependenciesOf(Graph<ComponentAst, ComponentAstEdge> graph,
                                                                  Set<ComponentAstEdge> seenEdges) {
    final Set<ComponentAstEdge> outgoing = new HashSet<>(graph.outgoingEdgesOf(getTarget()));
    outgoing.removeAll(seenEdges);
    seenEdges.addAll(outgoing);

    if (outgoing.isEmpty()) {
      return of(getTarget());
    } else {
      return outgoing.stream()
          .flatMap(outgoingEdge -> concat(of(outgoingEdge.getTarget()),
                                          outgoingEdge.doTransitiveOutgoingDependenciesOf(graph, seenEdges)));
    }
  }

  @Override
  protected ComponentAst getSource() {
    return (ComponentAst) super.getSource();
  }

  @Override
  public ComponentAst getTarget() {
    return (ComponentAst) super.getTarget();
  }

}
