/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.graph.api;

import org.mule.runtime.ast.api.ArtifactAst;

/**
 * A provider for {@link ArtifactAstDependencyGraph}'s.
 *
 * @since 1.2.0
 */
public interface ArtifactAstDependencyGraphProvider {

  /**
   * Gets an {@link ArtifactAstDependencyGraph} for the given {@link ArtifactAst}.
   *
   * @param fullArtifactAst the {@link ArtifactAst} to generate the graph for.
   * @return a graph instance with the dependencies between the artifact components resolved.
   *
   * @since 1.2.0
   */
  ArtifactAstDependencyGraph get(ArtifactAst fullArtifactAst);
}
