/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableWithSize;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.ast.graph.internal.ComponentAstEdge;
import org.mule.runtime.ast.graph.internal.DefaultArtifactAstDependencyGraph;
import org.mule.runtime.ast.test.internal.TestComponentAst;

@Issue(value="MULE-19984")
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DefaultArtifactAstDependencyGraphTestCase {
    private DefaultArtifactAstDependencyGraph artifactAstDependencyGraph;
    private ArtifactAst source;
    private Graph<ComponentAst, ComponentAstEdge> graph;
    private Set<ComponentAstDependency> missingDependencies;

    @Before
    public void setUp() throws Exception {
        this.source = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        this.graph = (Graph)Mockito.mock(SimpleDirectedGraph.class);
        this.missingDependencies = new HashSet<ComponentAstDependency>();
        this.artifactAstDependencyGraph = new DefaultArtifactAstDependencyGraph(this.source, this.graph, this.missingDependencies);
    }

    @Test
    @Description(value="If A depends on B, B depends on C, getRequiredComponents(A) will return a set of A, B, and C.")
    public void transitiveDependencyTest() {
        TestComponentAst componentA = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentB = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentC = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        Mockito.when(componentA.getComponentId()).thenReturn(Optional.of("componentA_name"));
        Mockito.when((Object)this.source.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(componentA));
        Mockito.when((Object)this.source.recursiveStream()).thenReturn(Stream.of(componentA));
        Mockito.when((Object)componentA.toString()).thenReturn((Object)"componentA");
        Mockito.when((Object)componentB.toString()).thenReturn((Object)"componentB");
        Mockito.when((Object)componentC.toString()).thenReturn((Object)"componentC");
        ComponentAstEdge edgeFromAToB = (ComponentAstEdge)Mockito.mock(ComponentAstEdge.class);
        ComponentAstEdge edgeFromBToC = (ComponentAstEdge)Mockito.mock(ComponentAstEdge.class);
        HashSet<ComponentAstEdge> outgoingEdgesOfA = new HashSet<ComponentAstEdge>();
        HashSet<ComponentAstEdge> outgoingEdgesOfB = new HashSet<ComponentAstEdge>();
        HashSet<ComponentAstEdge> edges = new HashSet<ComponentAstEdge>();
        Mockito.when((Object)edgeFromAToB.getSource()).thenReturn((Object)componentA);
        Mockito.when((Object)edgeFromAToB.getTarget()).thenReturn((Object)componentB);
        outgoingEdgesOfA.add(edgeFromAToB);
        Mockito.when((Object)edgeFromBToC.getSource()).thenReturn((Object)componentB);
        Mockito.when((Object)edgeFromBToC.getTarget()).thenReturn((Object)componentC);
        outgoingEdgesOfB.add(edgeFromBToC);
        edges.add(edgeFromAToB);
        edges.add(edgeFromBToC);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentA)).thenReturn(outgoingEdgesOfA);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentB)).thenReturn(outgoingEdgesOfB);
        Mockito.when((Object)edgeFromAToB.transitiveOutgoingDependenciesOf(this.graph)).thenReturn(Stream.of(new ComponentAst[]{componentA, componentB, componentC}));
        Set requiredComponents = this.artifactAstDependencyGraph.getRequiredComponents("componentA_name");
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)IsIterableWithSize.iterableWithSize((int)3));
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)Matchers.containsInAnyOrder((Object[])new ComponentAst[]{componentC, componentB, componentA}));
    }

    @Test
    @Description(value="If A depends on B, C depends on D, getRequiredComponents(A) will return a set of A and B only")
    public void separatedDependencyTest() {
        TestComponentAst componentA = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentB = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentC = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentD = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        Mockito.when(componentA.getComponentId()).thenReturn(Optional.of("componentA_name"));
        Mockito.when((Object)this.source.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(componentA));
        Mockito.when((Object)this.source.recursiveStream()).thenReturn(Stream.of(componentA));
        Mockito.when((Object)componentA.toString()).thenReturn((Object)"componentA");
        Mockito.when((Object)componentB.toString()).thenReturn((Object)"componentB");
        Mockito.when((Object)componentC.toString()).thenReturn((Object)"componentC");
        Mockito.when((Object)componentD.toString()).thenReturn((Object)"componentD");
        ComponentAstEdge edgeFromAToB = (ComponentAstEdge)Mockito.mock(ComponentAstEdge.class);
        ComponentAstEdge edgeFromCToD = (ComponentAstEdge)Mockito.mock(ComponentAstEdge.class);
        HashSet<ComponentAstEdge> outgoingEdgesOfA = new HashSet<ComponentAstEdge>();
        HashSet<ComponentAstEdge> outgoingEdgesOfC = new HashSet<ComponentAstEdge>();
        HashSet outgoingEdgesOfB = new HashSet();
        Mockito.when((Object)edgeFromAToB.getSource()).thenReturn((Object)componentA);
        Mockito.when((Object)edgeFromAToB.getTarget()).thenReturn((Object)componentB);
        outgoingEdgesOfA.add(edgeFromAToB);
        Mockito.when((Object)edgeFromCToD.getSource()).thenReturn((Object)componentC);
        Mockito.when((Object)edgeFromCToD.getTarget()).thenReturn((Object)componentD);
        outgoingEdgesOfC.add(edgeFromCToD);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentA)).thenReturn(outgoingEdgesOfA);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentB)).thenReturn(outgoingEdgesOfB);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentC)).thenReturn(outgoingEdgesOfC);
        Mockito.when((Object)edgeFromAToB.transitiveOutgoingDependenciesOf(this.graph)).thenReturn(Stream.of(new ComponentAst[]{componentA, componentB}));
        Set requiredComponents = this.artifactAstDependencyGraph.getRequiredComponents("componentA_name");
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)Matchers.containsInAnyOrder((Object[])new ComponentAst[]{componentA, componentB}));
    }

    @Test
    @Description(value="A depends on B, B is nested within C, C is of type CONFIG, getRequiredComponents(A) will return a set of A and B.")
    public void nestedConfigs() {
        TestComponentAst componentA = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentB = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        TestComponentAst componentC = (TestComponentAst)((Object)Mockito.mock(TestComponentAst.class));
        Mockito.when(componentA.getComponentId()).thenReturn(Optional.of("componentA_name"));
        Mockito.when((Object)componentA.toString()).thenReturn((Object)"componentA");
        Mockito.when((Object)componentB.toString()).thenReturn((Object)"componentB");
        Mockito.when((Object)componentC.toString()).thenReturn((Object)"componentC");
        Mockito.when((Object)componentC.getComponentType()).thenReturn((Object)TypedComponentIdentifier.ComponentType.CONFIG);
        Mockito.when((Object)componentC.recursiveStream()).thenReturn(Stream.of(componentB));
        Mockito.when((Object)this.source.topLevelComponentsStream()).thenAnswer(inv -> Stream.of(componentA, componentC));
        Mockito.when((Object)this.source.recursiveStream()).thenReturn(Stream.of(new ComponentAst[]{componentA, componentB, componentC}));
        ComponentAstEdge edgeFromAToB = (ComponentAstEdge)Mockito.mock(ComponentAstEdge.class);
        HashSet<ComponentAstEdge> outgoingEdgesOfA = new HashSet<ComponentAstEdge>();
        HashSet outgoingEdgesOfB = new HashSet();
        HashSet<ComponentAstEdge> edges = new HashSet<ComponentAstEdge>();
        Mockito.when((Object)edgeFromAToB.getSource()).thenReturn((Object)componentA);
        Mockito.when((Object)edgeFromAToB.getTarget()).thenReturn((Object)componentB);
        outgoingEdgesOfA.add(edgeFromAToB);
        edges.add(edgeFromAToB);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentA)).thenReturn(outgoingEdgesOfA);
        Mockito.when((Object)this.graph.outgoingEdgesOf((Object)componentB)).thenReturn(outgoingEdgesOfB);
        Mockito.when((Object)edgeFromAToB.transitiveOutgoingDependenciesOf(this.graph)).thenReturn(Stream.of(new ComponentAst[]{componentA, componentB}));
        Set requiredComponents = this.artifactAstDependencyGraph.getRequiredComponents("componentA_name");
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)IsIterableWithSize.iterableWithSize((int)2));
        MatcherAssert.assertThat((Object)requiredComponents, (Matcher)Matchers.containsInAnyOrder((Object[])new ComponentAst[]{componentB, componentA}));
    }
}

