/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.api;

import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsIterableContaining;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.ImmutableStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.ast.internal.DefaultComponentParameterAst;
import org.mule.runtime.ast.internal.builder.LightComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.ast.test.internal.TestArtifactAst;
import org.mule.runtime.ast.test.internal.TestComponentAst;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;

public class ArtifactAstDependencyGraphFactoryTestCase {
    @Test
    public void simpleTopLevelWithInner() {
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        TestComponentAst topLevel = new TestComponentAst(new ComponentAst[]{inner});
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{topLevel}));
        Collection topLevelMinimalComponents = graph.minimalArtifactFor((ComponentAst)topLevel).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
    }

    @Test
    public void simpleTopLevelWithInnerPredicate() {
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        TestComponentAst topLevel = new TestComponentAst(new ComponentAst[]{inner});
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{topLevel}));
        Collection topLevelMinimalComponents = graph.minimalArtifactFor(((ComponentAst)topLevel)::equals).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
    }

    @Test
    public void unrelatedComponents() {
        TestComponentAst innerA = new TestComponentAst(new ComponentAst[0]);
        TestComponentAst innerB = new TestComponentAst(new ComponentAst[0]);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    public void unrelatedComponentsPredicate() {
        TestComponentAst innerA = new TestComponentAst(new ComponentAst[0]);
        TestComponentAst innerB = new TestComponentAst(new ComponentAst[0]);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor(((ComponentAst)innerA)::equals).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor(((ComponentAst)innerB)::equals).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    public void noAllowedStereotypes() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        TestComponentAst innerB = new TestComponentAst(new ComponentAst[0]);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    public void unmatchingStereotypesUnmatchingName() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        TestComponentAst innerB = new TestComponentAst(new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "notMatchingDependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    public void matchingStereotypesUnmatchingName() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "notMatchingDependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    public void unmatchingStereotypesMatchingName() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NOT_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerB))));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    @Description(value="innerA.nameParam is a reference to innerB")
    public void matchingStereotypesMatchingName() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)innerA))));
    }

    @Test
    @Description(value="innerA.complexParam.nameParam is a reference to innerB")
    public void referenceFromComplexParam() {
        ObjectTypeBuilder complexTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        complexTypeBuilder.addField().required().key("nameParam").value((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build()).with((TypeAnnotation)new StereotypeTypeAnnotation(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)))).build();
        ObjectType complexType = complexTypeBuilder.build();
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel complexParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)complexParameterModel.getName()).thenReturn((Object)"complexParam");
        Mockito.when((Object)complexParameterModel.getType()).thenReturn((Object)complexType);
        ParameterGroupModel groupWithComplexParameter = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(complexParameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupWithComplexParameter));
        ParameterizedModel complexParameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build());
        ParameterGroupModel parameterGroupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)complexParameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(parameterGroupModel));
        ParameterGroupModel stGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)stGroup.getName()).thenReturn((Object)"General");
        ComponentIdentifier complexParamId = ComponentIdentifier.builder().namespace("mockns").name("complex-param").build();
        ComponentAstBuilder innerAComplexParam = this.buildOnce((ComponentAstBuilder)Mockito.spy((Object)new LightComponentAstBuilder(new ParameterModelUtils()).withParameterizedModel(complexParameterizedModel).withParameter(parameterModel, stGroup, (ComponentParameterAst)new DefaultComponentParameterAst("dependencyId", parameterModel, stGroup, ComponentGenerationInformation.EMPTY_GENERATION_INFO, new PropertiesResolver(), new ParameterModelUtils()), Optional.empty()))).withIdentifier(complexParamId);
        ParameterGroupModel complexGroup = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)complexGroup.getName()).thenReturn((Object)"General");
        ComponentAst innerA = new LightComponentAstBuilder(new ParameterModelUtils()).withParameterizedModel(parameterizedModel).withParameter(complexParameterModel, complexGroup, (ComponentParameterAst)new DefaultComponentParameterAst(innerAComplexParam, complexParameterModel, complexGroup, ComponentMetadataAst.EMPTY_METADATA, ComponentGenerationInformation.EMPTY_GENERATION_INFO, new PropertiesResolver(), new ParameterModelUtils()), Optional.of(complexParamId)).withIdentifier(ComponentIdentifier.builder().namespace("mockns").name("inner-a").build()).build();
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor(innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)innerA));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)innerAComplexParam.build()));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)innerA)));
    }

    @Test
    public void transitivesHandling() {
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        inner.setParameters(Collections.singletonMap("name", "inner"));
        TestComponentAst intermediateLevel = new TestComponentAst(new ComponentAst[]{inner});
        intermediateLevel.setParameters(Collections.singletonMap("name", "intermediate"));
        TestComponentAst topLevel = new TestComponentAst(new ComponentAst[]{intermediateLevel});
        topLevel.setParameters(Collections.singletonMap("name", "top"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{topLevel}));
        Collection topLevelMinimalComponents = graph.minimalArtifactFor((ComponentAst)topLevel).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)intermediateLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
        Collection innerLevelMinimalComponents = graph.minimalArtifactFor((ComponentAst)inner).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel))));
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)intermediateLevel))));
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
    }

    @Test
    public void transitivesHandlingPredicate() {
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        inner.setParameters(Collections.singletonMap("name", "inner"));
        TestComponentAst intermediateLevel = new TestComponentAst(new ComponentAst[]{inner});
        intermediateLevel.setParameters(Collections.singletonMap("name", "intermediate"));
        TestComponentAst topLevel = new TestComponentAst(new ComponentAst[]{intermediateLevel});
        topLevel.setParameters(Collections.singletonMap("name", "top"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{topLevel}));
        Collection topLevelMinimalComponents = graph.minimalArtifactFor(arg_0 -> topLevel.equals(arg_0)).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)intermediateLevel)));
        MatcherAssert.assertThat((Object)topLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
        Collection innerLevelMinimalComponents = graph.minimalArtifactFor(arg_0 -> inner.equals(arg_0)).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)topLevel))));
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsNot.not((Matcher)IsIterableContaining.hasItem((Object)((Object)intermediateLevel))));
        MatcherAssert.assertThat((Object)innerLevelMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)inner)));
    }

    @Test
    public void missingReported() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAstDependency missingDep = (ComponentAstDependency)graph.getMissingDependencies().iterator().next();
        MatcherAssert.assertThat((Object)missingDep.getName(), (Matcher)Is.is((Object)"dependencyId"));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsIterableContaining.hasItem((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
    }

    @Test
    @Issue(value="MULE-19865")
    public void inlineParamWithStereotypeNotMarkedAsMissingDependency() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setComplexParameters(Collections.singletonMap("nameParam", new TestComponentAst(new ComponentAst[0])));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    @Issue(value="MULE-17730")
    @Description(value="A missing dependency was not reported if another dependency for the same component is present")
    public void missingReportedButAnotherFound() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[]{new TestComponentAst(Mockito.mock(Object.class), new ComponentAst[0])});
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAstDependency missingDep = (ComponentAstDependency)graph.getMissingDependencies().iterator().next();
        MatcherAssert.assertThat((Object)missingDep.getName(), (Matcher)Is.is((Object)"dependencyId"));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsIterableContaining.hasItem((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
    }

    @Test
    @Description(value="Dependencies missing more than once are only reported once")
    public void missingReportedTwice() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        TestComponentAst innerB = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAstDependency missingDep = (ComponentAstDependency)graph.getMissingDependencies().iterator().next();
        MatcherAssert.assertThat((Object)missingDep.getName(), (Matcher)Is.is((Object)"dependencyId"));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsIterableContaining.hasItem((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
    }

    @Test
    public void missingDifferentStereotypeReported() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NOT_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAstDependency missingDep = (ComponentAstDependency)graph.getMissingDependencies().iterator().next();
        MatcherAssert.assertThat((Object)missingDep.getName(), (Matcher)Is.is((Object)"dependencyId"));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsIterableContaining.hasItem((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
    }

    @Test
    public void missingSameStereotypeReported() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.singletonMap("nameParam", "dependencyId"));
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "notMatchingDependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAstDependency missingDep = (ComponentAstDependency)graph.getMissingDependencies().iterator().next();
        MatcherAssert.assertThat((Object)missingDep.getName(), (Matcher)Is.is((Object)"dependencyId"));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)missingDep.getAllowedStereotypes(), (Matcher)IsIterableContaining.hasItem((Object)new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
    }

    @Test
    public void referencingParameterNotSet() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.emptyMap());
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NOT_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }

    @Test
    public void referencingParameterNotSetDefaultValue() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null)));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        Mockito.when((Object)parameterModel.getDefaultValue()).thenReturn((Object)"dependencyId");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenCallRealMethod();
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters(Collections.emptyMap());
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class);
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)new ImmutableStereotypeModel("ST_NOT_NAME", "ST_NAMESPACE", null));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        innerB.setParameters(Collections.singletonMap("name", "dependencyId"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        MatcherAssert.assertThat((Object)graph.getMissingDependencies(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void transitivesHandlingComparator() {
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        inner.setParameters(Collections.singletonMap("name", "inner"));
        TestComponentAst intermediateLevel = new TestComponentAst(new ComponentAst[]{inner});
        intermediateLevel.setParameters(Collections.singletonMap("name", "intermediate"));
        TestComponentAst topLevel = new TestComponentAst(new ComponentAst[]{intermediateLevel});
        topLevel.setParameters(Collections.singletonMap("name", "top"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{topLevel}));
        List<TestComponentAst> sorted = Arrays.asList(inner, intermediateLevel, topLevel);
        List<TestComponentAst> unorderedA = Arrays.asList(intermediateLevel, inner, topLevel);
        List<TestComponentAst> unorderedB = Arrays.asList(intermediateLevel, topLevel, inner);
        List<TestComponentAst> unorderedC = Arrays.asList(inner, topLevel, intermediateLevel);
        List<TestComponentAst> unorderedD = Arrays.asList(topLevel, inner, intermediateLevel);
        List<TestComponentAst> unorderedE = Arrays.asList(topLevel, intermediateLevel, inner);
        Collections.sort(unorderedA, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedA, (Matcher)Is.is(sorted));
        Collections.sort(unorderedB, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedB, (Matcher)Is.is(sorted));
        Collections.sort(unorderedC, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedC, (Matcher)Is.is(sorted));
        Collections.sort(unorderedD, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedD, (Matcher)Is.is(sorted));
        Collections.sort(unorderedE, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedE, (Matcher)Is.is(sorted));
    }

    @Test
    public void transitivesHandlingComparatorNotHandlingCorrectlyTopLevelElements() {
        TestComponentAst top1 = new TestComponentAst(new ComponentAst[0]);
        top1.setParameters(Collections.singletonMap("name", "top1"));
        TestComponentAst inner = new TestComponentAst(new ComponentAst[0]);
        inner.setParameters(Collections.singletonMap("name", "inner"));
        TestComponentAst top2 = new TestComponentAst(new ComponentAst[]{top1, inner});
        top2.setParameters(Collections.singletonMap("name", "top2"));
        TestComponentAst top3 = new TestComponentAst(new ComponentAst[]{top1});
        top3.setParameters(Collections.singletonMap("name", "top3"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{top1, top2, top3}));
        List<TestComponentAst> sorted = Arrays.asList(top1, inner, top3, top2);
        List<TestComponentAst> unordered = Arrays.asList(top1, top3, top2, inner);
        Collections.sort(unordered, graph.dependencyComparator());
        MatcherAssert.assertThat(unordered, (Matcher)Is.is(sorted));
    }

    @Test
    public void comparatorShouldWorkWithCyclicDependenciesInGraph() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasStereotypeModel.class}));
        ImmutableStereotypeModel stereotypeModel = new ImmutableStereotypeModel("ST_NAME", "ST_NAMESPACE", null);
        Mockito.when((Object)((HasStereotypeModel)parameterizedModel).getStereotype()).thenReturn((Object)stereotypeModel);
        List<StereotypeModel> stereotypeModelList = Arrays.asList(stereotypeModel);
        ParameterModel refParameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)refParameterModel.getAllowedStereotypes()).thenReturn(stereotypeModelList);
        Mockito.when((Object)refParameterModel.getName()).thenReturn((Object)"refParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(refParameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerA.setParameters((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"dependencyId1", (Object)"refParam", (Object)"dependencyId2"));
        TestComponentAst innerB = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        innerB.setParameters((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"dependencyId2", (Object)"refParam", (Object)"dependencyId1"));
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        Collection innerBMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerB).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
        MatcherAssert.assertThat((Object)innerBMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        List<TestComponentAst> sorted = Arrays.asList(innerB, innerA);
        List<TestComponentAst> unordered = Arrays.asList(innerA, innerB);
        Collections.sort(unordered, graph.dependencyComparator());
        MatcherAssert.assertThat(unordered, (Matcher)Is.is(sorted));
    }

    @Test
    public void unrelatedComponentsComparator() {
        TestComponentAst innerA = new TestComponentAst(new ComponentAst[0]);
        TestComponentAst innerB = new TestComponentAst(new ComponentAst[0]);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        List<ComponentAst> unorderedA = Arrays.asList(new ComponentAst[]{innerA, innerB});
        List<ComponentAst> unorderedB = Arrays.asList(new ComponentAst[]{innerB, innerA});
        Collections.sort(unorderedA, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedA, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Collections.sort(unorderedB, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedB, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void sameComponentsComparator() {
        TestComponentAst innerA;
        TestComponentAst innerB = innerA = new TestComponentAst(new ComponentAst[0]);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        List<ComponentAst> unorderedA = Arrays.asList(new ComponentAst[]{innerA, innerB});
        List<ComponentAst> unorderedB = Arrays.asList(new ComponentAst[]{innerB, innerA});
        Collections.sort(unorderedA, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedA, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Collections.sort(unorderedB, graph.dependencyComparator());
        MatcherAssert.assertThat(unorderedB, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void dependencyCycle() {
        ImmutableStereotypeModel stereotype1 = new ImmutableStereotypeModel("ST1_NAME", "ST_NAMESPACE", null);
        ImmutableStereotypeModel stereotype2 = new ImmutableStereotypeModel("ST2_NAME", "ST_NAMESPACE", null);
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasStereotypeModel.class}));
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getAllowedStereotypes()).thenReturn(Arrays.asList(stereotype1));
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameterModel);
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel));
        Mockito.when((Object)((HasStereotypeModel)parameterizedModel).getStereotype()).thenReturn((Object)stereotype2);
        TestComponentAst innerA = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        HashMap<String, String> rawParamsA = new HashMap<String, String>();
        rawParamsA.put("name", "dependency2Id");
        rawParamsA.put("nameParam", "dependencyId");
        innerA.setParameters(rawParamsA);
        HasStereotypeModel hasStereotypeModel = (HasStereotypeModel)Mockito.mock(HasStereotypeModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ParameterizedModel.class}));
        Mockito.when((Object)hasStereotypeModel.getStereotype()).thenReturn((Object)stereotype1);
        ParameterModel parameter2Model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameter2Model.getAllowedStereotypes()).thenReturn(Arrays.asList(stereotype2));
        Mockito.when((Object)parameter2Model.getName()).thenReturn((Object)"nameParam");
        ParameterGroupModel groupModel2 = ArtifactAstDependencyGraphFactoryTestCase.createMockParameterGroup(parameter2Model);
        Mockito.when((Object)((ParameterizedModel)hasStereotypeModel).getParameterGroupModels()).thenReturn(Collections.singletonList(groupModel2));
        TestComponentAst innerB = new TestComponentAst(hasStereotypeModel, new ComponentAst[0]);
        HashMap<String, String> rawParamsB = new HashMap<String, String>();
        rawParamsB.put("name", "dependencyId");
        rawParamsB.put("nameParam", "dependency2Id");
        innerB.setParameters(rawParamsB);
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{innerA, innerB}));
        Collection innerAMinimalComponents = graph.minimalArtifactFor((ComponentAst)innerA).recursiveStream().collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerA)));
        MatcherAssert.assertThat((Object)innerAMinimalComponents, (Matcher)IsIterableContaining.hasItem((Object)((Object)innerB)));
    }

    @Test
    @Issue(value="MULE-19193")
    public void recursiveStreamWithHierarchyOrphansAreNotTopLevel() {
        ParameterizedModel parameterizedModel = (ParameterizedModel)Mockito.mock(ParameterizedModel.class);
        TestComponentAst inner = new TestComponentAst(parameterizedModel, new ComponentAst[0]);
        TestComponentAst outer = new TestComponentAst(parameterizedModel, new ComponentAst[]{inner});
        ArtifactAstDependencyGraph graph = ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)new TestArtifactAst(new ComponentAst[]{outer}));
        ArtifactAst minimalArtifact = graph.minimalArtifactFor((ComponentAst)inner);
        List withHierarchy = MuleAstUtils.recursiveStreamWithHierarchy((ArtifactAst)minimalArtifact).collect(Collectors.toList());
        MatcherAssert.assertThat(withHierarchy, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)((List)((Pair)withHierarchy.get(0)).getSecond()), (Matcher)IsNot.not((Matcher)Matchers.empty()));
    }

    private ComponentAstBuilder buildOnce(ComponentAstBuilder paramComponent) {
        AtomicReference paramComp = new AtomicReference();
        ((ComponentAstBuilder)Mockito.doAnswer(inv -> paramComp.updateAndGet(alreadyBuilt -> {
            if (alreadyBuilt != null) {
                return alreadyBuilt;
            }
            try {
                return (ComponentAst)inv.callRealMethod();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        })).when((Object)paramComponent)).build();
        return paramComponent;
    }

    private static ParameterGroupModel createMockParameterGroup(ParameterModel ... parameterModels) {
        ParameterGroupModel groupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)groupModel.getName()).thenReturn((Object)"General");
        Mockito.when((Object)groupModel.getParameterModels()).thenReturn(Arrays.asList(parameterModels));
        return groupModel;
    }
}

