/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.message.error.matcher;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.ErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.SingleErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.WildcardErrorTypeMatcher;

public class ErrorTypeMatcherUtils {
    private ErrorTypeMatcherUtils() {
    }

    public static ErrorTypeMatcher createErrorTypeMatcher(ErrorType errorType) {
        return new SingleErrorTypeMatcher(errorType);
    }

    public static ErrorTypeMatcher createErrorTypeMatcher(ErrorTypeRepository errorTypeRepository, String errorTypeNames) {
        if (errorTypeNames == null) {
            return null;
        }
        String[] errorTypeIdentifiers = errorTypeNames.split(",");
        List<ErrorTypeMatcher> matchers = Arrays.stream(errorTypeIdentifiers).map(identifier -> {
            String parsedIdentifier = identifier.trim();
            ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation(parsedIdentifier);
            if (ErrorTypeMatcherUtils.doesErrorTypeContainWildcards(errorTypeComponentIdentifier)) {
                return new WildcardErrorTypeMatcher(errorTypeComponentIdentifier);
            }
            return new SingleErrorTypeMatcher(errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find ErrorType for the given identifier: '%s'", parsedIdentifier))));
        }).collect(Collectors.toList());
        return new DisjunctiveErrorTypeMatcher(matchers);
    }

    private static boolean doesErrorTypeContainWildcards(ComponentIdentifier errorTypeIdentifier) {
        if (errorTypeIdentifier == null) {
            return false;
        }
        if (Objects.equals(WildcardErrorTypeMatcher.WILDCARD_TOKEN, errorTypeIdentifier.getName())) {
            return true;
        }
        return Objects.equals(WildcardErrorTypeMatcher.WILDCARD_TOKEN, errorTypeIdentifier.getNamespace());
    }
}

