/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.metadata.descriptor;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;

public class ComponentMetadataTypesDescriptorTestCase {
    private MetadataType inputParamType;
    private MetadataType outputPayloadType;
    private MetadataType outputAttributesType;

    @Before
    public void setUp() {
        this.inputParamType = (MetadataType)Mockito.mock(MetadataType.class);
        this.outputPayloadType = (MetadataType)Mockito.mock(MetadataType.class);
        this.outputAttributesType = (MetadataType)Mockito.mock(MetadataType.class);
    }

    @Test
    public void keepsStaticMetadata() {
        ComponentMetadataTypesDescriptor descriptor = this.baseDescriptorBuilder(false).keepNonDynamicMetadata(true).build();
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getInputMetadata("param").get()), (Matcher)Matchers.sameInstance((Object)this.inputParamType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputPayloadType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputAttributesMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputAttributesType));
    }

    @Test
    public void keepsNotStaticMetadata() {
        ComponentMetadataTypesDescriptor descriptor = this.baseDescriptorBuilder(false).keepNonDynamicMetadata(false).build();
        MatcherAssert.assertThat((Object)descriptor.getInputMetadata("param"), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)descriptor.getOutputMetadata(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)descriptor.getOutputAttributesMetadata(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void keepsDynamicMetadata() {
        ComponentMetadataTypesDescriptor descriptor = this.baseDescriptorBuilder(true).keepNonDynamicMetadata(true).build();
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getInputMetadata("param").get()), (Matcher)Matchers.sameInstance((Object)this.inputParamType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputPayloadType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputAttributesMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputAttributesType));
    }

    @Test
    public void keepsDynamicMetadataButNotStaticMetadata() {
        ComponentMetadataTypesDescriptor descriptor = this.baseDescriptorBuilder(true).keepNonDynamicMetadata(false).build();
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getInputMetadata("param").get()), (Matcher)Matchers.sameInstance((Object)this.inputParamType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputPayloadType));
        MatcherAssert.assertThat((Object)((MetadataType)descriptor.getOutputAttributesMetadata().get()), (Matcher)Matchers.sameInstance((Object)this.outputAttributesType));
    }

    protected ComponentMetadataTypesDescriptor.ComponentMetadataTypesDescriptorBuilder baseDescriptorBuilder(boolean isDynamic) {
        return ComponentMetadataTypesDescriptor.builder().withInputMetadataDescriptor(((InputMetadataDescriptor.InputMetadataDescriptorBuilder)InputMetadataDescriptor.builder().withParameter("param", ParameterMetadataDescriptor.builder((String)"param").dynamic(isDynamic).withType(this.inputParamType).build())).build()).withOutputMetadataDescriptor(OutputMetadataDescriptor.builder().withReturnType(TypeMetadataDescriptor.builder().dynamic(isDynamic).withType(this.outputPayloadType).build()).withAttributesType(TypeMetadataDescriptor.builder().dynamic(isDynamic).withType(this.outputAttributesType).build()).build());
    }
}

