/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.metadata.MediaType;

@RunWith(value=Parameterized.class)
public class MediaTypeSerializationVersionsTestCase {
    @Parameterized.Parameter(value=0)
    public String versionFrom;
    @Parameterized.Parameter(value=1)
    public String versionTo;
    private ClassLoader toClassLoader;
    private Class toClass;

    @Parameterized.Parameters(name="from {0} to {1}")
    public static List<Object[]> params() {
        return Arrays.asList(new Object[][]{{"V11", "V10"}});
    }

    @Before
    public void before() throws ClassNotFoundException {
        this.toClassLoader = new ClassLoader(this.getClass().getClassLoader()){
            private Class definedClass;
            {
                this.definedClass = null;
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (MediaType.class.getName().equals(name)) {
                    if (this.definedClass != null) {
                        return this.definedClass;
                    }
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/media_type/MediaType" + MediaTypeSerializationVersionsTestCase.this.versionTo + ".class"));
                        this.definedClass = this.defineClass(name, classBytes, 0, classBytes.length);
                        return this.definedClass;
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name);
            }
        };
        this.toClass = this.toClassLoader.loadClass(MediaType.class.getName());
        Assert.assertThat((Object)this.toClass, (Matcher)Matchers.not((Matcher)Matchers.sameInstance(MediaType.class)));
    }

    @Test
    public void serializeDeserializeDefault() throws ClassNotFoundException, IOException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/media_type/mediaType" + this.versionFrom + ".ser");
        Object toMediaType = new ObjectWithClassLoaderInputStream(resourceAsStream, this.toClassLoader).readObject();
        Assert.assertThat(toMediaType.getClass(), (Matcher)Matchers.sameInstance((Object)this.toClass));
    }

    @Test
    public void serializeDeserializeDefinedInApp() throws ClassNotFoundException, IOException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/media_type/mediaType" + this.versionFrom + "DefinedInApp.ser");
        Object toMediaType = new ObjectWithClassLoaderInputStream(resourceAsStream, this.toClassLoader).readObject();
        Assert.assertThat(toMediaType.getClass(), (Matcher)Matchers.sameInstance((Object)this.toClass));
    }

    private final class ObjectWithClassLoaderInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        private ObjectWithClassLoaderInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return this.classLoader.loadClass(desc.getName());
        }
    }
}

