/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util.collection;

import io.qameta.allure.Issue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.api.util.collection.SmallMap;

@RunWith(value=Parameterized.class)
public class SmallMapTestCase {
    private static final String[] KEYS = new String[]{"one", "two", "three", "four", "five", "six", "seven"};
    private static final String[] VALUES = new String[]{"uno", "dos", "tres", "cuatro", "cinco", "seis", "siete"};
    private final int mapSize;
    private Map<String, String> map = new SmallMap();

    @Parameterized.Parameters(name="with Size: {0}")
    public static Iterable<Integer> data() {
        return (Iterable)IntStream.range(0, 8).boxed().collect(Collectors.toImmutableList());
    }

    public SmallMapTestCase(int mapSize) {
        this.mapSize = mapSize;
    }

    @Before
    public void before() {
        Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        this.populate(this.mapSize);
    }

    private void populate(int size) {
        this.populate(size, this.map);
    }

    private void populate(int size, Map<String, String> map) {
        map.clear();
        for (int i = 0; i < size; ++i) {
            map.put(KEYS[i], VALUES[i]);
            Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)(i + 1)));
            Assert.assertThat((Object)map.containsKey(KEYS[i]), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)map.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void putRepeatedKeys() {
        for (int i = 0; i < this.mapSize; ++i) {
            Assert.assertThat((Object)this.map.put(KEYS[i], VALUES[i].toUpperCase()), (Matcher)CoreMatchers.is((Object)VALUES[i]));
            Assert.assertThat((Object)this.map.get(KEYS[i]), (Matcher)CoreMatchers.equalTo((Object)VALUES[i].toUpperCase()));
            Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)this.mapSize));
            Assert.assertThat((Object)this.map.containsKey(KEYS[i]), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void isEmpty() {
        Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)(this.mapSize == 0 ? 1 : 0)));
    }

    @Test
    public void removeKeysInRandomOrder() {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            this.populate(this.mapSize);
            HashSet<Integer> removedKeyIndex = new HashSet<Integer>();
            while (!this.map.isEmpty()) {
                int index;
                while (!removedKeyIndex.add(index = random.nextInt(this.mapSize))) {
                }
                Assert.assertThat((Object)this.map.remove(KEYS[index]), (Matcher)CoreMatchers.is((Object)VALUES[index]));
                Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)(removedKeyIndex.size() == this.mapSize ? 1 : 0)));
                Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)(this.mapSize - removedKeyIndex.size())));
            }
        }
        Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void putAll() {
        int i;
        this.map.clear();
        String originalKey = "original";
        String originalValue = "value";
        this.map.put(originalKey, originalValue);
        HashMap<String, String> other = new HashMap<String, String>();
        int otherMapSize = 5;
        for (i = 0; i < otherMapSize; ++i) {
            other.put(String.valueOf(i), "_" + i);
        }
        other.put(originalKey, originalValue);
        this.map.putAll(other);
        Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)(otherMapSize + 1)));
        Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        for (i = 0; i < otherMapSize; ++i) {
            String key = String.valueOf(i);
            String value = "_" + i;
            Assert.assertThat((Object)this.map.containsKey(key), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.map.containsValue(value), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.map.get(key), (Matcher)CoreMatchers.equalTo((Object)value));
        }
        Assert.assertThat((Object)this.map.containsKey(originalKey), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.map.containsValue(originalValue), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.map.get(originalKey), (Matcher)CoreMatchers.equalTo((Object)originalValue));
    }

    @Test
    public void clear() {
        this.map.clear();
        Assert.assertThat((Object)this.map.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)0));
        this.populate(this.mapSize);
    }

    @Test
    public void entrySet() {
        this.map.entrySet().forEach(entry -> {
            int i = this.getKeyIndex((String)entry.getKey());
            Assert.assertThat((Object)((String)entry.getValue()), (Matcher)CoreMatchers.equalTo((Object)VALUES[i]));
        });
    }

    @Test
    public void keySet() {
        Set<String> values = this.map.keySet();
        Assert.assertThat(values, (Matcher)Matchers.hasSize((int)this.mapSize));
        for (int i = 0; i < this.mapSize; ++i) {
            Assert.assertThat((Object)values.contains(KEYS[i]), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void contains() {
        for (int i = 0; i < this.mapSize; ++i) {
            Assert.assertThat((Object)this.map.containsValue(VALUES[i]), (Matcher)CoreMatchers.is((Object)true));
        }
        Assert.assertThat((Object)this.map.containsValue("bleh"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void values() {
        Collection<String> values = this.map.values();
        Assert.assertThat(values, (Matcher)Matchers.hasSize((int)this.mapSize));
        for (int i = 0; i < this.mapSize; ++i) {
            Assert.assertThat((Object)values.contains(VALUES[i]), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void remove() {
        int i = 0;
        while (i < this.mapSize) {
            Assert.assertThat((Object)this.map.remove(KEYS[i]), (Matcher)CoreMatchers.is((Object)VALUES[i]));
            Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)(this.mapSize - ++i)));
        }
    }

    @Test
    public void mutateEntry() {
        this.map.entrySet().forEach(entry -> entry.setValue(((String)entry.getValue()).toUpperCase()));
        for (int i = 0; i < this.map.size(); ++i) {
            Assert.assertThat((Object)this.map.get(KEYS[i]), (Matcher)CoreMatchers.equalTo((Object)VALUES[i].toUpperCase()));
        }
    }

    @Test
    public void size() {
        Assert.assertThat((Object)this.map.size(), (Matcher)CoreMatchers.is((Object)this.mapSize));
    }

    @Test
    public void mapToString() {
        SmallMap map = new SmallMap();
        map.put("a", "b");
        map.put("c", "d");
        Assert.assertThat((Object)map.toString(), (Matcher)CoreMatchers.equalTo((Object)"{a=b, c=d}"));
    }

    @Test
    public void equals() {
        HashMap<String, String> other = new HashMap<String, String>();
        this.populate(this.mapSize, other);
        Assert.assertThat(this.map, (Matcher)CoreMatchers.equalTo(other));
        other.remove(KEYS[0]);
        if (this.mapSize > 0) {
            Assert.assertThat(this.map, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(other)));
        }
    }

    @Test
    public void setToString() {
        SmallMap map = new SmallMap();
        map.put("a", "b");
        map.put("c", "d");
        Assert.assertThat((Object)map.toString(), (Matcher)CoreMatchers.equalTo((Object)"{a=b, c=d}"));
    }

    private int getKeyIndex(String key) {
        for (int i = 0; i < KEYS.length; ++i) {
            if (!KEYS[i].equals(key)) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    @Test
    @Issue(value="MULE-19180")
    public void unmodifiableMapUsingSmallMap() {
        Map unmodifiableMap = SmallMap.unmodifiable(this.map);
        Assert.assertThat(this.map, (Matcher)CoreMatchers.not((Matcher)Matchers.sameInstance((Object)unmodifiableMap)));
        Map unmodifiable2 = SmallMap.unmodifiable((Map)unmodifiableMap);
        Assert.assertThat((Object)unmodifiableMap, (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)unmodifiable2)));
    }

    @Test
    @Issue(value="MULE-19180")
    public void unmodifiableMapUsingMap() {
        Map<String, String> source = Collections.singletonMap("key", "value");
        Map unmodifiableMap = SmallMap.unmodifiable(source);
        Assert.assertThat(source, (Matcher)CoreMatchers.not((Matcher)Matchers.sameInstance((Object)unmodifiableMap)));
        Map unmodifiable2 = SmallMap.unmodifiable((Map)unmodifiableMap);
        Assert.assertThat((Object)unmodifiableMap, (Matcher)CoreMatchers.is((Matcher)Matchers.sameInstance((Object)unmodifiable2)));
    }
}

