/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.meta.model;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;

public class ElementDeclarationLocationPathTestCase {
    private ArtifactDeclaration multiFlowDeclaration;

    @Before
    public void setup() throws Exception {
        this.multiFlowDeclaration = ElementDeclarationLocationPathTestCase.createMultiFlowArtifactDeclaration();
    }

    @Test
    public void globalConfig() throws Exception {
        Location location = Location.builder().globalName("config").build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ConfigurationElementDeclaration)element.get()).getRefName(), (Matcher)Is.is((Object)"config"));
    }

    @Test
    public void getConnection() throws Exception {
        Location location = Location.builder().globalName("config").addConnectionPart().build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ConnectionElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"active-mq-connection"));
    }

    @Test
    public void globalFlow() throws Exception {
        Location location = Location.builder().globalName("bridge").build();
        MatcherAssert.assertThat((Object)this.multiFlowDeclaration.findElement(location).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void messageProcessor() throws Exception {
        Location location = Location.builder().globalName("send-payload").addProcessorsPart().addIndexPart(0).build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"publish"));
    }

    @Test
    public void scope() throws Exception {
        Location location = Location.builder().globalName("bridge").addProcessorsPart().addIndexPart(1).build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"foreach"));
    }

    @Test
    public void messageProcessorInScope() throws Exception {
        Location location = Location.builder().globalName("bridge").addProcessorsPart().addIndexPart(1).addProcessorsPart().addIndexPart(1).build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"logger"));
    }

    @Test
    public void messageSource() throws Exception {
        Location location = Location.builder().globalName("testFlow").addSourcePart().build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"listener"));
    }

    @Test
    public void messageProcessorParameter() throws Exception {
        Location location = Location.builder().globalName("bridge").addProcessorsPart().addIndexPart(0).addParameterPart().addPart("destination").build();
        Optional element = this.multiFlowDeclaration.findElement(location);
        MatcherAssert.assertThat((Object)element.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ElementDeclaration)element.get()).getName(), (Matcher)Is.is((Object)"destination"));
    }

    private static ArtifactDeclaration createMultiFlowArtifactDeclaration() {
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"Mule Core");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)jms.newConfiguration("config").withRefName("config").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)jms.newConnection("active-mq-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("cachingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extensions.jms.api.connection.caching.NoCachingConfiguration").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("send-payload").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", "#[payload]").withParameter("properties", "#[{(initialProperty): propertyValue}]").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").withParameter("maximumWait", "1000").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[finalDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("jmsxProperties", "#[attributes.properties.jmsxProperties]").withParameter("body", "#[bridgePrefix ++ payload]").withParameter("properties", "#[attributes.properties.userProperties]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "Message Sent").getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge-receiver").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[finalDestination]").withParameter("maximumWait", "1000").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("host", "localhost").withParameter("port", "49019").withParameter("protocol", "HTTPS").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("request-config").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request-connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("host", "localhost").withParameter("port", "49020").withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", "user").withParameter("password", "pass").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", "1000").withParameter("keepAlive", "true").withParameter("receiveBufferSize", "1024").withParameter("sendBufferSize", "1024").withParameter("clientTimeout", "1000").withParameter("linger", "1000").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("initialState", "stopped").getDeclaration())).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", "#[{{'content-type' : 'text/plain'}}]").withParameter("body", "#[{'my': 'map'}]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", "#[true]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[finalDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", "#[bridgePrefix ++ payload]").getDeclaration())).getDeclaration()).getDeclaration())).withRoute((RouteElementDeclaration)core.newRoute("otherwise").withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", "#[myCollection]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }
}

