/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.SerializableLazyValue;

public class SerializableLazyValueTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void serializeUninitialized() throws Exception {
        SerializableLazyValue original = new SerializableLazyValue(() -> 1);
        LazyValue processed = (LazyValue)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)original)));
        this.assertSerialization((LazyValue)original, processed);
    }

    @Test
    public void serializeInitialized() throws Exception {
        SerializableLazyValue original = new SerializableLazyValue(() -> 1);
        original.get();
        LazyValue processed = (LazyValue)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)original)));
        this.assertSerialization((LazyValue)original, processed);
    }

    private void assertSerialization(LazyValue original, LazyValue processed) {
        MatcherAssert.assertThat((Object)original.isComputed(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)processed.isComputed())));
        MatcherAssert.assertThat((Object)original.get(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)processed.get())));
    }
}

