/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.meta.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.json.JSONException;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SimpleValueType;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.skyscreamer.jsonassert.JSONAssert;

public class ArtifactDeclarationJsonSerializerTestCase {
    private ArtifactDeclaration applicationDeclaration;

    @Before
    public void setup() {
        this.applicationDeclaration = this.createArtifact();
    }

    @Test
    public void serializationTest() {
        JsonParser parser = new JsonParser();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(this.getClass().getResourceAsStream(this.getExpectedArtifactDeclarationJson())));
        JsonElement expected = parser.parse(reader);
        JsonElement json = parser.parse(ArtifactDeclarationJsonSerializer.getDefault((boolean)true).serialize(this.applicationDeclaration));
        MatcherAssert.assertThat((Object)json, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void serializeDeserializeTest() {
        ArtifactDeclarationJsonSerializer serializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String json = serializer.serialize(this.applicationDeclaration);
        ArtifactDeclaration artifactDeclaration = serializer.deserialize(json);
        MatcherAssert.assertThat((String)json, (Object)this.applicationDeclaration, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)artifactDeclaration)));
    }

    @Test
    public void serializeDeserializeSerializeTest() throws JSONException {
        ArtifactDeclarationJsonSerializer serializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String originalJson = serializer.serialize(this.applicationDeclaration);
        ArtifactDeclaration loadedDeclaration = serializer.deserialize(originalJson);
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(ArtifactDeclarationJsonSerializer.getDefault((boolean)true).serialize(loadedDeclaration));
        String generatedJson = jsonElement.toString();
        JSONAssert.assertEquals((String)originalJson, (String)generatedJson, (boolean)true);
    }

    @Test
    public void equalsTopLevelParameterShouldIncludeParameters() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ParameterObjectValue parameterObjectValue = ParameterObjectValue.builder().withParameter("otherName", "simpleParam").build();
        String globalParameterName = "globalParameterName";
        String globalTemplateRefName = "globalTemplateRefName";
        ParameterObjectValue modifiedParameterObjectValue = ParameterObjectValue.builder().withParameter("otherName", "simpleParam").withParameter("myCamelCaseName", "someContent").build();
        MatcherAssert.assertThat((Object)((ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)core.newGlobalParameter(globalParameterName).withRefName(globalTemplateRefName).withValue(parameterObjectValue).getDeclaration()).getDeclaration()), (Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)((ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)core.newGlobalParameter(globalParameterName).withRefName(globalTemplateRefName).withValue(modifiedParameterObjectValue).getDeclaration()).getDeclaration()))));
    }

    private ArtifactDeclaration createArtifact() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer sockets = ElementDeclarer.forExtension((String)"Sockets");
        ElementDeclarer wsc = ElementDeclarer.forExtension((String)"Web Service Consumer");
        ElementDeclarer file = ElementDeclarer.forExtension((String)"File");
        ElementDeclarer os = ElementDeclarer.forExtension((String)"ObjectStore");
        return (ArtifactDeclaration)((ArtifactDeclarer)ElementDeclarer.newArtifact().withCustomParameter("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("configuration").withParameterGroup(group -> group.withParameter("defaultErrorHandler-ref", this.createStringParameter("referableHandler")))).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("errorHandler").withRefName("referableHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup(group -> group.withParameter("type", this.createStringParameter("MULE:SOURCE_RESPONSE")).withParameter("logException", this.createBooleanParameter("false")).withParameter("enableNotifications", this.createBooleanParameter("false")))).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup(group -> group.withParameter("level", this.createStringParameter("TRACE")))).getDeclaration()).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newGlobalParameter("objectStore").withRefName("persistentStore").withValue(ElementDeclarer.newObjectValue().ofType("org.mule.extension.objectstore.api.TopLevelObjectStore").withParameter("entryTtl", this.createNumberParameter("1")).withParameter("entryTtlUnit", this.createStringParameter("HOURS")).withParameter("maxEntries", this.createNumberParameter("10")).withParameter("persistent", this.createBooleanParameter("true")).withParameter("expirationInterval", this.createNumberParameter("2")).withParameter("expirationIntervalUnit", this.createStringParameter("HOURS")).withParameter("config-ref", this.createStringParameter("persistentConfig")).build()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newConfiguration("config").withRefName("persistentConfig").getDeclaration()).withGlobalElement((GlobalElementDeclaration)file.newConfiguration("config").withRefName("fileConfig").withConnection((ConnectionElementDeclaration)file.newConnection("connection").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)wsc.newConfiguration("config").withRefName("wscConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.extension.api.ExpirationPolicy").withParameter("maxIdleTime", this.createNumberParameter("1")).withParameter("timeUnit", this.createStringParameter(TimeUnit.MINUTES.name())).build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)wsc.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("soapVersion", this.createStringParameter("SOAP11")).withParameter("mtomEnabled", this.createBooleanParameter("false")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("wsdlLocation", this.createStringParameter("http://www.webservicex.com/globalweather.asmx?WSDL")).withParameter("address", this.createStringParameter("http://www.webservicex.com/globalweather.asmx")).withParameter("service", this.createStringParameter("GlobalWeather")).withParameter("port", this.createStringParameter("GlobalWeatherSoap")).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", this.createNumberParameter("10")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", this.createStringParameter("propertyOne")).withParameter("second", this.createStringParameter("propertyTwo")).build()).withParameter("reconnection", (ParameterValue)ElementDeclarer.newObjectValue().ofType("Reconnection").withParameter("failsDeployment", this.createBooleanParameter("true")).withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", this.createNumberParameter("1")).withParameter("frequency", this.createNumberParameter("0")).build()).build()).withParameter("database", this.createStringParameter("target/muleEmbeddedDB")).withParameter("create", this.createBooleanParameter("true")).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", this.createStringParameter("/")).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", this.createStringParameter("ssltest-keystore.jks")).withParameter("password", this.createStringParameter("changeit")).withParameter("keyPassword", this.createStringParameter("changeit")).build()).withParameter("trust-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("insecure", this.createBooleanParameter("true")).build()).withParameter("revocation-check", (ParameterValue)ElementDeclarer.newObjectValue().ofType("standard-revocation-check").withParameter("onlyEndEntities", this.createBooleanParameter("true")).build()).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("host", this.createStringParameter("localhost")).withParameter("port", this.createNumberParameter("49019")).withParameter("protocol", this.createStringParameter("HTTPS")))).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request").withParameterGroup(group -> group.withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", this.createStringParameter("user")).withParameter("password", this.createStringParameter("pass")).build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", this.createStringParameter("localhost")).withParameter("port", this.createNumberParameter("49020")).withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", this.createNumberParameter("1000")).withParameter("keepAlive", this.createBooleanParameter("true")).withParameter("receiveBufferSize", this.createNumberParameter("1024")).withParameter("sendBufferSize", this.createNumberParameter("1024")).withParameter("clientTimeout", this.createNumberParameter("1000")).withParameter("linger", this.createNumberParameter("1000")).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withCustomParameter("doc:id", "docUUID")).withParameterGroup(group -> group.withParameter("initialState", this.createStringParameter("stopped")))).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withCustomParameter("doc:id", "docUUID")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", this.createStringParameter("testBuilder")).withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", this.createNumberParameter("2")).withParameter("useSecureHash", this.createBooleanParameter("true")).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", this.createNumberParameter("1")).withParameter("frequency", this.createNumberParameter("0")).build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", this.createStringCdataParameter("<![CDATA[#[{{'content-type' : 'text/plain'}}]]]>")).withParameter("body", this.createStringCdataParameter("<![CDATA[#[\n                    %dw 2.0\n                    output application/json\n                    input payload application/xml\n                    var baseUrl=\"http://sample.cloudhub.io/api/v1.0/\"\n                    ---\n                    using (pageSize = payload.getItemsResponse.PageInfo.pageSize) {\n                         links: [\n                            {\n                                href: fullUrl,\n                                rel : \"self\"\n                            }\n                         ],\n                         collection: {\n                            size: pageSize,\n                            items: payload.getItemsResponse.*Item map {\n                                id: $.id,\n                                type: $.type,\n                                name: $.name\n                            }\n                         }\n                    }\n                ]]>")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", this.createStringParameter("#[true]")).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", this.createStringParameter("INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", this.createStringParameter("name")).withParameter("type", this.createStringParameter("VARCHAR")).build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", this.createNumberParameter("position")).withParameter("type", this.createStringParameter("INTEGER")).build()).build()).getDeclaration())).getDeclaration()).getDeclaration())).withRoute((RouteElementDeclaration)core.newRoute("otherwise").withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", this.createStringParameter("#[myCollection]")).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", this.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", this.createStringParameter("INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", this.createStringParameter("name")).withParameter("type", this.createStringParameter("VARCHAR")).build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", this.createStringParameter("position")).withParameter("type", this.createStringParameter("INTEGER")).build()).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", this.createStringParameter("/nested")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", this.createStringParameter("POST")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("insert").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", this.createStringParameter("INSERT INTO PLANET(POSITION, NAME, DESCRIPTION) VALUES (777, 'Pluto', :description)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", this.createStringParameter("description")).withParameter("type", this.createStringParameter("CLOB")).build()).build()).withParameter("inputParameters", this.createStringParameter("#[{{'description' : payload}}]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)sockets.newOperation("sendAndReceive").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-in-memory-stream").withParameter("bufferSizeIncrement", this.createNumberParameter("8")).withParameter("bufferUnit", this.createStringParameter("KB")).withParameter("initialBufferSize", this.createNumberParameter("51")).withParameter("maxBufferSize", this.createNumberParameter("1000")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Output").withParameter("target", this.createStringParameter("myVar")).withParameter("targetValue", this.createStringParameter("#[message]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("try").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)wsc.newOperation("consume").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("operation", this.createStringParameter("GetCitiesByCountry")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("attachments", this.createStringParameter("#[{}]")).withParameter("headers", this.createStringParameter("#[{\"headers\": {con#headerIn: \"Header In Value\",con#headerInOut: \"Header In Out Value\"}]")).withParameter("body", this.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("errorHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", this.createStringParameter("MULE:ANY")).getDeclaration())).withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration()).getDeclaration())).withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorPropagate").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", this.createStringParameter("WSC:CONNECTIVITY")).withParameter("when", this.createStringParameter("#[e.cause == null]")).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("schedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler").withParameter("frequency", this.createNumberParameter("50")).withParameter("startDelay", this.createNumberParameter("20")).withParameter("timeUnit", this.createStringParameter("SECONDS")).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", this.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("cronSchedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", this.createStringParameter("0/1 * * * * ?")).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", this.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    protected String getExpectedArtifactDeclarationJson() {
        return "/declaration/artifact-declaration.json";
    }

    private ParameterValue createNumberParameter(String value) {
        return this.createPlainParameter(value, SimpleValueType.NUMBER);
    }

    private ParameterValue createBooleanParameter(String value) {
        return this.createPlainParameter(value, SimpleValueType.BOOLEAN);
    }

    private ParameterValue createStringParameter(String value) {
        SimpleValueType type = SimpleValueType.STRING;
        return this.createPlainParameter(value, type);
    }

    private ParameterValue createStringCdataParameter(String value) {
        return this.createCdataParameter(value, SimpleValueType.STRING);
    }

    private ParameterValue createPlainParameter(String value, SimpleValueType type) {
        return ParameterSimpleValue.plain((String)value, (SimpleValueType)type);
    }

    private ParameterValue createCdataParameter(String value, SimpleValueType type) {
        return ParameterSimpleValue.cdata((String)value, (SimpleValueType)type);
    }
}

