/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.streaming;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.mule.runtime.api.streaming.bytes.ImmutableFileRepeatableInputStream;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class ImmutableFileRepeatableInputStreamTestCase {
    public static final String CONTENT = "Hello World!";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private File file;

    @Before
    public void before() throws Exception {
        this.file = this.temporaryFolder.newFile();
        FileUtils.writeStringToFile((File)this.file, (String)CONTENT, (Charset)Charset.defaultCharset());
    }

    @Test
    public void readFile() throws Exception {
        ImmutableFileRepeatableInputStream stream = new ImmutableFileRepeatableInputStream(this.file, false);
        Assert.assertThat((Object)IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.equalTo((Object)CONTENT));
        Assert.assertThat((Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void closeAndKeepFile() throws Exception {
        ImmutableFileRepeatableInputStream stream = new ImmutableFileRepeatableInputStream(this.file, false);
        Assert.assertThat((Object)IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.equalTo((Object)CONTENT));
        stream.close();
        Assert.assertThat((Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void closeAndAutoDelete() throws Exception {
        ImmutableFileRepeatableInputStream stream = new ImmutableFileRepeatableInputStream(this.file, true);
        Assert.assertThat((Object)IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset()), (Matcher)CoreMatchers.equalTo((Object)CONTENT));
        stream.close();
        Assert.assertThat((Object)this.file.exists(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void fileDoesNotExists() {
        String fileName = "notthere.bin";
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(FileNotFoundException.class));
        new ImmutableFileRepeatableInputStream(new File(this.temporaryFolder.getRoot(), "notthere.bin"), true);
    }

    @Test
    public void getFile() {
        ImmutableFileRepeatableInputStream stream = new ImmutableFileRepeatableInputStream(this.file, true);
        Assert.assertThat((Object)stream.getFile().getAbsolutePath(), (Matcher)CoreMatchers.equalTo((Object)this.file.getAbsolutePath()));
    }

    @Test
    public void isAutoDelete() {
        ImmutableFileRepeatableInputStream stream = new ImmutableFileRepeatableInputStream(this.file, true);
        Assert.assertThat((Object)stream.isAutoDelete(), (Matcher)CoreMatchers.is((Object)true));
        stream = new ImmutableFileRepeatableInputStream(this.file, false);
        Assert.assertThat((Object)stream.isAutoDelete(), (Matcher)CoreMatchers.is((Object)false));
    }
}

