/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.util.DataUnit;

public class DataUnitTestCase {
    private static final int ONE = 1;
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int ONE_GB = 0x40000000;

    @Test
    public void testBtoB() {
        MatcherAssert.assertThat((Object)DataUnit.BYTE.toBytes(0x40000000), (Matcher)Is.is((Object)0x40000000));
    }

    @Test
    public void testBtoKB() {
        MatcherAssert.assertThat((Object)DataUnit.BYTE.toKB(0x40000000), (Matcher)Is.is((Object)0x100000));
    }

    @Test
    public void testBtoMB() {
        MatcherAssert.assertThat((Object)DataUnit.BYTE.toMB(0x40000000), (Matcher)Is.is((Object)1024));
    }

    @Test
    public void testBtoGB() {
        MatcherAssert.assertThat((Object)DataUnit.BYTE.toGB(0x40000000), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testKBtoB() {
        MatcherAssert.assertThat((Object)DataUnit.KB.toBytes(0x100000), (Matcher)Is.is((Object)0x40000000));
    }

    @Test
    public void testKBtoKB() {
        MatcherAssert.assertThat((Object)DataUnit.KB.toKB(0x100000), (Matcher)Is.is((Object)0x100000));
    }

    @Test
    public void testKBtoMB() {
        MatcherAssert.assertThat((Object)DataUnit.KB.toMB(0x100000), (Matcher)Is.is((Object)1024));
    }

    @Test
    public void testKBtoGB() {
        MatcherAssert.assertThat((Object)DataUnit.KB.toGB(0x100000), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testMBtoB() {
        MatcherAssert.assertThat((Object)DataUnit.MB.toBytes(1024), (Matcher)Is.is((Object)0x40000000));
    }

    @Test
    public void testMBtoKB() {
        MatcherAssert.assertThat((Object)DataUnit.MB.toKB(1024), (Matcher)Is.is((Object)0x100000));
    }

    @Test
    public void testMBtoMB() {
        MatcherAssert.assertThat((Object)DataUnit.MB.toMB(1024), (Matcher)Is.is((Object)1024));
    }

    @Test
    public void testMBtoGB() {
        MatcherAssert.assertThat((Object)DataUnit.MB.toGB(1024), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testGBtoB() {
        MatcherAssert.assertThat((Object)DataUnit.GB.toBytes(1), (Matcher)Is.is((Object)0x40000000));
    }

    @Test
    public void testGBtoKB() {
        MatcherAssert.assertThat((Object)DataUnit.GB.toKB(1), (Matcher)Is.is((Object)0x100000));
    }

    @Test
    public void testGBtoMB() {
        MatcherAssert.assertThat((Object)DataUnit.GB.toMB(1), (Matcher)Is.is((Object)1024));
    }

    @Test
    public void testGBtoGB() {
        MatcherAssert.assertThat((Object)DataUnit.GB.toGB(1), (Matcher)Is.is((Object)1));
    }
}

