/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleExceptionInfo;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;

public class MuleExceptionInfoTestCase {
    MuleExceptionInfo muleExceptionInfo = null;
    private final ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);

    @Before
    public void before() {
        Mockito.when((Object)this.errorType.toString()).thenReturn((Object)"MULE:TESTING");
        this.muleExceptionInfo = new MuleExceptionInfo();
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenCausedByExistsThenIsAddedToSummary() {
        StringBuilder summaryMessage = new StringBuilder();
        this.muleExceptionInfo.addSuppressedCause((MuleException)new TestMuleException("Caused by error"));
        this.muleExceptionInfo.addToSummaryMessage(summaryMessage);
        Assert.assertThat((Object)summaryMessage.toString(), (Matcher)Matchers.containsString((String)"Caused by             : Caused by error"));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenCausedByErrorTypeExistsThenIsAddedToSummary() {
        StringBuilder summaryMessage = new StringBuilder();
        this.muleExceptionInfo.addSuppressedCause((MuleException)new TestMuleException("Caused by error", this.errorType));
        this.muleExceptionInfo.addToSummaryMessage(summaryMessage);
        Assert.assertThat((Object)summaryMessage.toString(), (Matcher)Matchers.containsString((String)"Caused by             : MULE:TESTING: Caused by error"));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenCausedByNotExistsThenIsNotAddedToSummary() {
        StringBuilder summaryMessage = new StringBuilder();
        this.muleExceptionInfo.addToSummaryMessage(summaryMessage);
        Assert.assertThat((Object)summaryMessage.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Caused by error")));
    }

    private static class TestMuleException
    extends MuleException {
        private static final long serialVersionUID = -8941618124275385459L;

        public TestMuleException(String message) {
            super(I18nMessageFactory.createStaticMessage((String)message));
        }

        public TestMuleException(String message, ErrorType errorType) {
            super(I18nMessageFactory.createStaticMessage((String)message));
            this.getExceptionInfo().setErrorType(errorType);
        }
    }
}

