/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.exception;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.DefaultExceptionReader;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.legacy.exception.ExceptionReader;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.internal.exception.SuppressedMuleException;

public class ExceptionHelperTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ClassLoader originalTccl;
    private ClassLoader cl1;
    private ClassLoader cl2;
    private ExceptionReader cl1Reader;
    private ExceptionReader cl2Reader;
    private ErrorType dummyErrorType = new ErrorType(){
        private static final long serialVersionUID = -5155728711167777541L;

        public String getIdentifier() {
            return "TEST_ERROR";
        }

        public String getNamespace() {
            return "TST";
        }

        public ErrorType getParentErrorType() {
            return null;
        }
    };

    @Before
    public void before() throws Exception {
        this.originalTccl = Thread.currentThread().getContextClassLoader();
        this.cl1 = new TestChildClassLoader(ExceptionHelperTestCase.class.getClassLoader());
        this.cl2 = new TestChildClassLoader(ExceptionHelperTestCase.class.getClassLoader());
        this.cl1Reader = (ExceptionReader)this.cl1.loadClass(TestExceptionReader.class.getName()).newInstance();
        this.cl2Reader = (ExceptionReader)this.cl2.loadClass(TestExceptionReader.class.getName()).newInstance();
        ExceptionHelper.registerExceptionReader((ExceptionReader)this.cl1Reader);
        ExceptionHelper.registerExceptionReader((ExceptionReader)this.cl2Reader);
    }

    @After
    public void after() {
        ExceptionHelper.unregisterExceptionReader((ExceptionReader)this.cl1Reader);
        ExceptionHelper.unregisterExceptionReader((ExceptionReader)this.cl2Reader);
        Thread.currentThread().setContextClassLoader(this.originalTccl);
    }

    @Test
    public void differentClassLoaders() throws Exception {
        Assert.assertThat((Object)ExceptionHelper.getExceptionReader((Throwable)new Exception()), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DefaultExceptionReader.class)));
    }

    @Test
    public void sameRegisterClassLoaderClassLoader() throws Exception {
        Thread.currentThread().setContextClassLoader(this.cl1);
        Assert.assertThat((Object)ExceptionHelper.getExceptionReader((Throwable)new Exception()), (Matcher)Matchers.is((Object)this.cl1Reader));
        Thread.currentThread().setContextClassLoader(this.cl2);
        Assert.assertThat((Object)ExceptionHelper.getExceptionReader((Throwable)new Exception()), (Matcher)Matchers.is((Object)this.cl2Reader));
    }

    @Test
    public void childRegisterClassLoaderClassLoader() throws Exception {
        Thread.currentThread().setContextClassLoader(new ClassLoader(this.cl1){});
        Assert.assertThat((Object)ExceptionHelper.getExceptionReader((Throwable)new Exception()), (Matcher)Matchers.is((Object)this.cl1Reader));
        Thread.currentThread().setContextClassLoader(new ClassLoader(this.cl2){});
        Assert.assertThat((Object)ExceptionHelper.getExceptionReader((Throwable)new Exception()), (Matcher)Matchers.is((Object)this.cl2Reader));
    }

    @Test
    public void registerOverridesGlobal() throws Exception {
        ExceptionHelper.registerGlobalExceptionReader((ExceptionReader)new TestAbstractExceptionReader(){

            public Class<?> getExceptionType() {
                return TestException.class;
            }
        });
        this.expected.expect(IllegalArgumentException.class);
        ExceptionHelper.registerExceptionReader((ExceptionReader)new TestAbstractExceptionReader(){

            public Class<?> getExceptionType() {
                return TestException.class;
            }
        });
    }

    @Test
    public void registerGlobalNotFromRuntime() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        ExceptionHelper.registerGlobalExceptionReader((ExceptionReader)this.cl1Reader);
    }

    @Test
    public void unsuppressedMuleExceptionInGetRootMuleException() {
        ConnectionException innerCause = new ConnectionException((Throwable)new NullPointerException());
        TypedException errorWithUnsuppressedCause = new TypedException((Throwable)innerCause, this.dummyErrorType);
        Assert.assertThat((Object)ExceptionHelper.getRootMuleException((Throwable)errorWithUnsuppressedCause), (Matcher)Matchers.is((Object)innerCause));
    }

    @Test
    public void suppressedMuleExceptionInGetRootMuleException() {
        ConnectionException innerCause = new ConnectionException((Throwable)new NullPointerException());
        TypedException errorWithSuppressedCause = new TypedException((Throwable)new SuppressedMuleException((Throwable)innerCause), this.dummyErrorType);
        Assert.assertThat((Object)ExceptionHelper.getRootMuleException((Throwable)errorWithSuppressedCause), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void unsuppressedMuleExceptionInGetExceptionsAsList() {
        NullPointerException rootCause = new NullPointerException("Root Cause");
        ConnectionException innerCause = new ConnectionException((Throwable)rootCause);
        TypedException errorWithUnsuppressedCause = new TypedException((Throwable)innerCause, this.dummyErrorType);
        List exceptionsList = ExceptionHelper.getExceptionsAsList((Throwable)errorWithUnsuppressedCause);
        Assert.assertThat((Object)exceptionsList, (Matcher)Matchers.contains((Object[])new Throwable[]{rootCause, innerCause, errorWithUnsuppressedCause}));
    }

    @Test
    public void suppressedMuleExceptionInGetExceptionsAsList() {
        ConnectionException innerCause = new ConnectionException((Throwable)new NullPointerException());
        TypedException errorWithSuppressedCause = new TypedException((Throwable)new SuppressedMuleException((Throwable)innerCause), this.dummyErrorType);
        List exceptionsList = ExceptionHelper.getExceptionsAsList((Throwable)errorWithSuppressedCause);
        Assert.assertThat((Object)exceptionsList, (Matcher)Matchers.contains((Object[])new Throwable[]{errorWithSuppressedCause}));
    }

    public static class TestException
    extends Exception {
    }

    public static class TestExceptionReader
    extends TestAbstractExceptionReader {
        public Class<?> getExceptionType() {
            return Exception.class;
        }
    }

    public static abstract class TestAbstractExceptionReader
    implements ExceptionReader {
        public String getMessage(Throwable t) {
            return t.getMessage();
        }

        public Throwable getCause(Throwable t) {
            return t.getCause();
        }

        public Map<String, Object> getInfo(Throwable t) {
            return Collections.emptyMap();
        }
    }

    private static final class TestChildClassLoader
    extends ClassLoader {
        private TestChildClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.endsWith("TestExceptionReader")) {
                try {
                    byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/" + name.replaceAll("\\.", "/") + ".class"));
                    return this.defineClass(null, classBytes, 0, classBytes.length);
                }
                catch (Exception e) {
                    return super.loadClass(name);
                }
            }
            return super.loadClass(name);
        }
    }
}

