/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.internal.event.ItemSequenceInfoBindingWrapper;

public class BindingContextUtils {
    public static final String MESSAGE = "message";
    public static final String PAYLOAD = "payload";
    public static final String DATA_TYPE = "dataType";
    public static final String ATTRIBUTES = "attributes";
    public static final String ERROR = "error";
    public static final String CORRELATION_ID = "correlationId";
    public static final String VARS = "vars";
    public static final String AUTHENTICATION = "authentication";
    public static final String FLOW = "flow";
    public static final String ITEM_SEQUENCE_INFO = "itemSequenceInfo";
    public static final BindingContext NULL_BINDING_CONTEXT = new BindingContext(){

        @Override
        public Collection<ExpressionModule> modules() {
            return Collections.emptySet();
        }

        @Override
        public Optional<TypedValue> lookup(String identifier) {
            return Optional.empty();
        }

        @Override
        public Collection<String> identifiers() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Binding> bindings() {
            return Collections.emptySet();
        }
    };
    private static final DataType VARS_DATA_TYPE = DataType.builder().mapType(Map.class).keyType(String.class).valueType(TypedValue.class).build();
    private static final DataType ITEM_SEQUENCE_INFO_DATA_TYPE = DataType.fromType(ItemSequenceInfoBindingWrapper.class);
    private static final DataType MESAGE_DATA_TYPE = DataType.fromType(Message.class);
    private static final DataType DATA_TYPE_DATA_TYPE = DataType.fromType(DataType.class);
    private static final DataType ERROR_DATA_TYPE = DataType.fromType(Error.class);
    private static final DataType AUTH_DATA_TYPE = DataType.fromType(Authentication.class);
    private static final DataType FLOW_DATA_TYPE = DataType.fromType(FlowVariablesAccessor.class);
    public static final TypedValue EMPTY_VARS = new TypedValue(Collections.emptyMap(), VARS_DATA_TYPE);
    private static final Supplier<TypedValue> EMPTY_VARS_SUPPLIER = () -> EMPTY_VARS;
    public static final TypedValue NULL_TYPED_VALUE = new TypedValue<Object>(null, DataType.OBJECT);
    private static final Supplier<TypedValue> NULL_TYPED_VALUE_SUPPLIER = () -> NULL_TYPED_VALUE;

    private BindingContextUtils() {
    }

    public static BindingContext addEventBindings(Event event, BindingContext baseContext) {
        return BindingContextUtils.addEventBuindingsToBuilder(event, baseContext).build();
    }

    public static BindingContext.Builder addEventBuindingsToBuilder(Event event, BindingContext baseContext) {
        BindingContext.Builder contextBuilder;
        Objects.requireNonNull(event);
        Objects.requireNonNull(baseContext);
        BindingContext.Builder builder = contextBuilder = baseContext == NULL_BINDING_CONTEXT ? BindingContext.builder() : BindingContext.builder(baseContext);
        if (!event.getVariables().isEmpty()) {
            contextBuilder.addBinding(VARS, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue(event.getVariables(), VARS_DATA_TYPE)));
        } else {
            contextBuilder.addBinding(VARS, EMPTY_VARS_SUPPLIER);
        }
        contextBuilder.addBinding(CORRELATION_ID, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<String>(event.getContext().getCorrelationId(), DataType.STRING)));
        if (event.getItemSequenceInfo().isPresent()) {
            contextBuilder.addBinding(ITEM_SEQUENCE_INFO, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<ItemSequenceInfoBindingWrapper>(new ItemSequenceInfoBindingWrapper(event.getItemSequenceInfo().get()), ITEM_SEQUENCE_INFO_DATA_TYPE)));
        } else {
            contextBuilder.addBinding(ITEM_SEQUENCE_INFO, NULL_TYPED_VALUE_SUPPLIER);
        }
        Message message = event.getMessage();
        contextBuilder.addBinding(MESSAGE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<MessageWrapper>(new MessageWrapper(message), MESAGE_DATA_TYPE)));
        contextBuilder.addBinding(ATTRIBUTES, message.getAttributes());
        contextBuilder.addBinding(PAYLOAD, message.getPayload());
        contextBuilder.addBinding(DATA_TYPE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<DataType>(message.getPayload().getDataType(), DATA_TYPE_DATA_TYPE)));
        if (event.getError().isPresent()) {
            contextBuilder.addBinding(ERROR, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<Error>(event.getError().get(), ERROR_DATA_TYPE)));
        } else {
            contextBuilder.addBinding(ERROR, NULL_TYPED_VALUE_SUPPLIER);
        }
        if (event.getAuthentication().isPresent()) {
            contextBuilder.addBinding(AUTHENTICATION, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<Authentication>(event.getAuthentication().get(), AUTH_DATA_TYPE)));
        } else {
            contextBuilder.addBinding(AUTHENTICATION, NULL_TYPED_VALUE_SUPPLIER);
        }
        return contextBuilder;
    }

    public static BindingContext.Builder addFlowNameBindingsToBuilder(ComponentLocation location, BindingContext.Builder contextBuilder) {
        return contextBuilder.addBinding(FLOW, () -> new TypedValue<FlowVariablesAccessor>(new FlowVariablesAccessor(location.getRootContainerName()), FLOW_DATA_TYPE));
    }

    public static BindingContext getTargetBindingContext(Message message) {
        Objects.requireNonNull(message);
        return BindingContext.builder().addBinding(MESSAGE, new LazyValue<Supplier<TypedValue>>(() -> new TypedValue<MessageWrapper>(new MessageWrapper(message), MESAGE_DATA_TYPE))).addBinding(PAYLOAD, message.getPayload()).addBinding(ATTRIBUTES, message.getAttributes()).build();
    }

    private static class MessageWrapper
    implements Message {
        private static final long serialVersionUID = -8097230480930728693L;
        private Message message;

        public MessageWrapper(Message message) {
            this.message = message;
        }

        @Override
        public <T> TypedValue<T> getPayload() {
            return this.message.getPayload();
        }

        @Override
        public <T> TypedValue<T> getAttributes() {
            return this.message.getAttributes();
        }

        public String toString() {
            return this.message.toString();
        }
    }

    private static class FlowVariablesAccessor {
        private String name;

        public FlowVariablesAccessor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

