/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;

public class MediaTypeSerializationTestCase {
    @Test
    public void readFromV10() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("media_type/mediaTypeV10.ser");
        ObjectInputStream objectInputStream = new ObjectInputStream(resourceAsStream);
        Object o = objectInputStream.readObject();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.instanceOf(MediaType.class));
        MediaType parsed = (MediaType)o;
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
    }

    @Test
    public void readFromV11() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("media_type/mediaTypeV11.ser");
        ObjectInputStream objectInputStream = new ObjectInputStream(resourceAsStream);
        Object o = objectInputStream.readObject();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.instanceOf(MediaType.class));
        MediaType parsed = (MediaType)o;
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
    }

    @Test
    public void readFromV11DefinedInApp() throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("media_type/mediaTypeV11DefinedInApp.ser");
        ObjectInputStream objectInputStream = new ObjectInputStream(resourceAsStream);
        Object o = objectInputStream.readObject();
        Assert.assertThat((Object)o, (Matcher)CoreMatchers.instanceOf(MediaType.class));
        MediaType parsed = (MediaType)o;
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
    }
}

