/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.queue;

public final class DefaultQueueConfiguration implements QueueConfiguration {

  private final boolean persistent;
  private final int capacity;

  public DefaultQueueConfiguration() {
    this(QueueConfiguration.MAXIMUM_CAPACITY, false);
  }

  public DefaultQueueConfiguration(int capacity, boolean isPersistent) {
    this.capacity = capacity;
    this.persistent = isPersistent;
  }

  @Override
  public boolean isPersistent() {
    return persistent;
  }

  @Override
  public int getCapacity() {
    return capacity;
  }

  @Override
  public String toString() {
    return String.format("DefaultQueueConfiguration{" + "persistent=%s, capacity=%s}", persistent, capacity);
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!obj.getClass().equals(this.getClass())) {
      return false;
    }
    DefaultQueueConfiguration other = (DefaultQueueConfiguration) obj;
    return persistent == other.persistent && capacity == other.capacity;
  }
}
