/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.queue;

import org.mule.api.annotation.NoImplement;

/**
 * Queue configuration attributes.
 *
 * @since 1.10.
 */
@NoImplement
public interface QueueConfiguration {

  int MAXIMUM_CAPACITY = 0;

  /**
   * @return if the queue is persistent.
   */
  boolean isPersistent();

  /**
   * @return the capacity of the queue.
   */
  int getCapacity();

}
