/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.metadata;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;

public class MediaTypeUtilsTestCase {
    @Test
    public void anyTextMimeTypeIsStringRepresentable() {
        MatcherAssert.assertThat((Object)MediaTypeUtils.isStringRepresentable((MediaType)MediaType.parse((String)"text/lalalalalalala")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void applicationJsonIsStringRepresentable() {
        MatcherAssert.assertThat((Object)MediaTypeUtils.isStringRepresentable((MediaType)MediaType.JSON), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void binaryTypeIsNotStringRepresentable() {
        MatcherAssert.assertThat((Object)MediaTypeUtils.isStringRepresentable((MediaType)MediaType.parse((String)"application/octet-stream")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void applicationXmlIsFoundInStringRepresentableMimeTypes() {
        MatcherAssert.assertThat((Object)MediaTypeUtils.getStringRepresentableMimeTypes(), (Matcher)IsCollectionContaining.hasItem((Object)MediaType.APPLICATION_XML));
    }

    @Test(expected=NullPointerException.class)
    public void mediaTypeIsRequired() {
        MediaTypeUtils.isStringRepresentable(null);
    }
}

