/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;

public class StereotypesTestCase {
    private StereotypeModel rootA = StereotypeModelBuilder.newStereotype((String)"root", (String)"A").build();
    private StereotypeModel rootB = StereotypeModelBuilder.newStereotype((String)"root", (String)"B").build();
    private StereotypeModel midA = StereotypeModelBuilder.newStereotype((String)"mid", (String)"A").withParent(this.rootA).build();
    private StereotypeModel midB = StereotypeModelBuilder.newStereotype((String)"mid", (String)"B").withParent(this.rootB).build();
    private StereotypeModel leafA = StereotypeModelBuilder.newStereotype((String)"leaf", (String)"A").withParent(this.midA).build();
    private StereotypeModel leafB = StereotypeModelBuilder.newStereotype((String)"leaf", (String)"B").withParent(this.midB).build();

    @Test
    public void assignableEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.rootA.isAssignableTo(this.rootA), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.midA.isAssignableTo(this.midA), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(this.leafA), (Matcher)Is.is((Object)true));
    }

    @Test
    public void assignableByParent() throws Exception {
        MatcherAssert.assertThat((Object)this.midA.isAssignableTo(this.rootA), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(this.rootA), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(this.midA), (Matcher)Is.is((Object)true));
    }

    @Test
    public void nonAssignabletoOthersParent() throws Exception {
        MatcherAssert.assertThat((Object)this.midA.isAssignableTo(this.midB), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(this.leafB), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(this.midB), (Matcher)Is.is((Object)false));
    }

    @Test
    public void nonAssignableDifferentLeaf() throws Exception {
        MatcherAssert.assertThat((Object)this.midA.isAssignableTo(this.leafA), (Matcher)Is.is((Object)false));
        StereotypeModel otherLeaf = StereotypeModelBuilder.newStereotype((String)"other", (String)"A").withParent(this.midA).build();
        MatcherAssert.assertThat((Object)this.leafA.isAssignableTo(otherLeaf), (Matcher)Is.is((Object)false));
    }

    @Test
    public void assignableShouldNotBeNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.midA.isAssignableTo(null));
    }

    @Test
    public void stereotypePropertiesShouldNotBeNull() {
        MatcherAssert.assertThat((Object)this.rootA.getType(), (Matcher)Is.is((Object)"ROOT"));
        MatcherAssert.assertThat((Object)this.rootA.getNamespace(), (Matcher)Is.is((Object)"A"));
        MatcherAssert.assertThat((Object)this.rootA.getParent(), (Matcher)Is.isA(Optional.class));
    }

    @Test
    public void stereotypeHashCodeShouldNotBeNull() {
        MatcherAssert.assertThat((Object)this.midA.hashCode(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void stereotypeToStringShouldNotBeNull() {
        MatcherAssert.assertThat((Object)this.midA.toString(), (Matcher)IsNull.notNullValue());
    }
}

