/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public class MulePolicyModel
extends AbstractMuleArtifactModel {
    private Set<String> supportedJavaVersions;

    private MulePolicyModel() {
    }

    private MulePolicyModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptor, Set<String> supportedJavaVersions) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptor);
        this.supportedJavaVersions = supportedJavaVersions;
    }

    public Set<String> getSupportedJavaVersions() {
        return this.supportedJavaVersions == null ? Collections.emptySet() : Collections.unmodifiableSet(this.supportedJavaVersions);
    }

    public static class MulePolicyModelBuilder
    extends AbstractMuleArtifactModelBuilder<MulePolicyModelBuilder, MulePolicyModel> {
        private Set<String> supportedJavaVersions = Collections.emptySet();

        @Override
        protected MulePolicyModelBuilder getThis() {
            return this;
        }

        @Override
        public MulePolicyModel build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return new MulePolicyModel(this.getName(), this.getMinMuleVersion(), this.getRequiredProduct(), this.getClassLoaderModelDescriptorLoader(), this.getBundleDescriptorLoader(), this.supportedJavaVersions);
        }

        public void setSupportedJavaVersions(Set<String> supportedJavaVersions) {
            this.supportedJavaVersions = Objects.requireNonNull(supportedJavaVersions);
        }
    }
}

