/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.message;

import java.util.ServiceLoader;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleMessageBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleMessageBuilderFactory.class);
    private static final AbstractMuleMessageBuilderFactory DEFAULT_FACTORY = AbstractMuleMessageBuilderFactory.loadFactory();

    private static AbstractMuleMessageBuilderFactory loadFactory() {
        try {
            AbstractMuleMessageBuilderFactory factory = ServiceLoader.load(AbstractMuleMessageBuilderFactory.class, MuleImplementationLoaderUtils.getMuleImplementationsLoader()).iterator().next();
            LOGGER.info(String.format("Loaded MuleMessageBuilderFactory implementation '%s' from classloader '%s'", factory.getClass().getName(), factory.getClass().getClassLoader().toString()));
            return factory;
        }
        catch (Throwable t) {
            LOGGER.error("Error loading MuleMessageBuilderFactory implementation.", t);
            throw t;
        }
    }

    static final AbstractMuleMessageBuilderFactory getDefaultFactory() {
        if (MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
            return AbstractMuleMessageBuilderFactory.loadFactory();
        }
        return DEFAULT_FACTORY;
    }

    protected abstract Message.PayloadBuilder create();

    protected abstract Message.Builder create(Message var1);
}

