/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;

@RunWith(value=Parameterized.class)
public class ComponentRepresentationTestCase {
    @Parameterized.Parameter(value=0)
    public Supplier<? extends Component> componentFactory;

    @Parameterized.Parameters(name="{index}: fib[{0}]={1}")
    public static Iterable<Supplier<? extends Component>> data() {
        ArrayList<Supplier<? extends Component>> params = new ArrayList<Supplier<? extends Component>>();
        params.add(() -> new TestAbstractComponent());
        params.add(() -> new TestComponent());
        return params;
    }

    @Test
    public void representations() {
        Component comp = this.componentFactory.get();
        HashMap<QName, String> annotations = new HashMap<QName, String>();
        annotations.put(Component.Annotations.REPRESENTATION_ANNOTATION_KEY, "representation");
        comp.setAnnotations(annotations);
        MatcherAssert.assertThat((Object)comp.getRepresentation(), (Matcher)Is.is((Object)"representation"));
    }

    @Test
    public void locations() {
        Component comp = this.componentFactory.get();
        HashMap<QName, Object> annotations = new HashMap<QName, Object>();
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        annotations.put(AbstractComponent.LOCATION_KEY, location);
        annotations.put(AbstractComponent.ROOT_CONTAINER_NAME_KEY, "rootContainer");
        comp.setAnnotations(annotations);
        MatcherAssert.assertThat((Object)comp.getLocation(), (Matcher)Matchers.sameInstance((Object)location));
        MatcherAssert.assertThat((Object)comp.getRootContainerLocation().toString(), (Matcher)Is.is((Object)"rootContainer"));
    }

    private static class TestComponent
    implements Component {
        private Map<QName, Object> annotations;

        private TestComponent() {
        }

        public Object getAnnotation(QName name) {
            return this.annotations.get(name);
        }

        public Map<QName, Object> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<QName, Object> annotations) {
            this.annotations = annotations;
        }

        public ComponentLocation getLocation() {
            return (ComponentLocation)this.getAnnotation(AbstractComponent.LOCATION_KEY);
        }

        public Location getRootContainerLocation() {
            return Location.builder().globalName((String)this.getAnnotation(AbstractComponent.ROOT_CONTAINER_NAME_KEY)).build();
        }
    }

    private static class TestAbstractComponent
    extends AbstractComponent {
        private TestAbstractComponent() {
        }
    }
}

