/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;

class DefaultComponentIdentifier
implements ComponentIdentifier,
Serializable {
    private static final long serialVersionUID = -7904681927277956932L;
    private String namespace;
    private String namespaceLowerCase;
    private String name;

    private DefaultComponentIdentifier() {
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static ComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)componentIdentifier), "identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = "mule";
            identifier = values[0];
        }
        return new Builder().namespace(namespace).name(identifier).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentIdentifier that = (DefaultComponentIdentifier)o;
        if (!this.namespaceLowerCase.equals(that.namespaceLowerCase)) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        int result = this.namespaceLowerCase.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.getNamespace().equals("mule") ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static class Builder
    implements ComponentIdentifier.Builder {
        private final DefaultComponentIdentifier componentIdentifier = new DefaultComponentIdentifier();

        @Override
        public Builder namespace(String namespace) {
            this.componentIdentifier.namespace = namespace;
            this.componentIdentifier.namespaceLowerCase = namespace.toLowerCase();
            return this;
        }

        @Override
        public Builder name(String identifier) {
            this.componentIdentifier.name = identifier;
            return this;
        }

        @Override
        public ComponentIdentifier build() {
            Preconditions.checkState(this.componentIdentifier.namespace != null && !this.componentIdentifier.namespace.trim().isEmpty(), "Prefix URI must be not blank");
            Preconditions.checkState(this.componentIdentifier.name != null && !this.componentIdentifier.name.trim().isEmpty(), "Name must be not blank");
            return this.componentIdentifier;
        }
    }
}

