/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import javax.xml.namespace.QName;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;

@NoExtend
public class ComponentLocationProvider {
    protected static final QName NAME_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");

    public static String resolveProcessorRepresentation(String appId, String processorPath, Object element) {
        String docName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(processorPath).append(" @ ").append(appId);
        String sourceFile = ComponentLocationProvider.getSourceFile((Component)element);
        if (sourceFile != null) {
            stringBuilder.append(":").append(sourceFile).append(":").append(ComponentLocationProvider.getSourceFileLine((Component)element));
        }
        if ((docName = ComponentLocationProvider.getDocName(element)) != null) {
            stringBuilder.append(" (").append(docName).append(")");
        }
        return stringBuilder.toString();
    }

    public static String getDocName(Object element) {
        if (element instanceof Component) {
            Object docName = ((Component)element).getAnnotation(NAME_ANNOTATION_KEY);
            return docName != null ? docName.toString() : null;
        }
        return null;
    }

    protected static String getSourceFile(Component component) {
        return component.getLocation() != null ? component.getLocation().getFileName().orElse("unknown") : "internal";
    }

    protected static Integer getSourceFileLine(Component component) {
        return component.getLocation() != null ? component.getLocation().getLineInFile().orElse(-1) : Integer.valueOf(-1);
    }

    public static String getSourceCode(Component component) {
        return (String)component.getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceElement"));
    }
}

