/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.util.Preconditions;

public class MuleApplicationModel
extends AbstractMuleArtifactModel {
    private final List<String> configs;
    private final String domain;
    private final boolean redeploymentEnabled;

    private MuleApplicationModel(String name, String minMuleVersion, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptor, List<String> configs, Optional<String> domain, Optional<Boolean> redeploymentEnabled) {
        super(name, minMuleVersion, classLoaderModelLoaderDescriptor, bundleDescriptor);
        this.configs = configs == null ? new ArrayList() : configs;
        this.domain = domain.orElse(null);
        this.redeploymentEnabled = redeploymentEnabled.orElse(true);
    }

    public List<String> getConfigs() {
        return this.configs == null ? Collections.emptyList() : Collections.unmodifiableList(this.configs);
    }

    public Optional<String> getDomain() {
        return Optional.ofNullable(this.domain);
    }

    public boolean isRedeploymentEnabled() {
        return this.redeploymentEnabled;
    }

    public static class MuleApplicationModelBuilder
    extends AbstractMuleArtifactModelBuilder<MuleApplicationModelBuilder, MuleApplicationModel> {
        private List<String> configs = new ArrayList<String>();
        private String domain;
        private Boolean redeploymentEnabled;

        public void setConfigs(List<String> configs) {
            this.configs = configs;
        }

        @Override
        protected MuleApplicationModelBuilder getThis() {
            return this;
        }

        @Override
        public MuleApplicationModel build() {
            Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return new MuleApplicationModel(this.getName(), this.getMinMuleVersion(), this.getClassLoaderModelDescriptorLoader(), this.getBundleDescriptorLoader(), this.configs, Optional.ofNullable(this.domain), Optional.ofNullable(this.redeploymentEnabled));
        }

        public MuleApplicationModelBuilder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public void setRedeploymentEnabled(boolean redeploymentEnabled) {
            this.redeploymentEnabled = redeploymentEnabled;
        }
    }
}

