/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.app.declaration;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.app.declaration.ComponentElementDeclaration;
import org.mule.runtime.api.app.declaration.ElementDeclaration;
import org.mule.runtime.api.app.declaration.SourceElementDeclaration;

public class ScopeElementDeclaration
extends ComponentElementDeclaration {
    private List<ComponentElementDeclaration> components = new LinkedList<ComponentElementDeclaration>();

    public ScopeElementDeclaration() {
    }

    public ScopeElementDeclaration(String extension, String name) {
        this.setDeclaringExtension(extension);
        this.setName(name);
    }

    public List<ComponentElementDeclaration> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public ScopeElementDeclaration addComponent(ComponentElementDeclaration declaration) {
        this.components.add(declaration);
        return this;
    }

    public ScopeElementDeclaration addComponent(int index, ComponentElementDeclaration declaration) {
        this.components.add(index, declaration);
        return this;
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        if (this.components.isEmpty()) {
            return Optional.empty();
        }
        String identifier = parts.get(0);
        if (StringUtils.isNumeric((CharSequence)identifier) && Integer.parseInt(identifier) < this.components.size()) {
            return this.components.get(Integer.parseInt(identifier)).findElement(parts.subList(1, parts.size()));
        }
        if (identifier.equals("errorHandler")) {
            ComponentElementDeclaration last = this.components.get(this.components.size() - 1);
            return last instanceof ScopeElementDeclaration ? last.findElement(parts.subList(1, parts.size())) : Optional.empty();
        }
        if (this.isProcessorLocation(parts)) {
            int processorIndex = Integer.parseInt(parts.get(1));
            if (this.components.get(0) instanceof SourceElementDeclaration) {
                if (this.components.size() == 1) {
                    return Optional.empty();
                }
                ++processorIndex;
            }
            return this.components.get(processorIndex).findElement(parts.subList(2, parts.size()));
        }
        return super.findElement(parts);
    }

    private boolean isProcessorLocation(List<String> parts) {
        return parts.get(0).equals("processors") && parts.size() > 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        ScopeElementDeclaration that = (ScopeElementDeclaration)o;
        return this.components.equals(that.components);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.components.hashCode();
        return result;
    }
}

